package nashid.verify.sdk.mrtd2.passportutils;

import nashid.verify.sdk.Constant;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DateUtil {

    public static Date stringToDate(String dateStr, DateFormat dateFormat) {
        Date date = null;
        try {
            date = dateFormat.parse(dateStr);
        } catch (ParseException e) {
            e.printStackTrace();
        }

        return date;
    }

    public static String dateToString(Date date, DateFormat dateFormat) {
        return dateFormat.format(date);
    }

    public static String convertFromMrzDate(String mrzDate) {
        Date date = stringToDate(mrzDate, new SimpleDateFormat("yyMMdd", Locale.getDefault()));
        return dateToString(date, new SimpleDateFormat(Constant.DATEFORMATE, Locale.getDefault()));
    }

    public static String convertFromMrzDateDG12(String mrzDate) {
        Date date = stringToDate(mrzDate, new SimpleDateFormat("yyyyMMdd", Locale.getDefault()));
        return dateToString(date, new SimpleDateFormat(Constant.passportDateFormate, Locale.getDefault()));
    }
}
