package nashid.verify.sdk.networking;


import nashid.verify.sdk.networking.models.AutoCrop;
import nashid.verify.sdk.networking.models.ValidationResponse;
import nashid.verify.sdk.networking.models.featurecheck.FeatureCheck;
import nashid.verify.sdk.networking.models.nashidfeaturecheck.NashidFeatureCheck;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.Part;
import retrofit2.http.Query;

public interface APIInterface {

    @POST("/api/check")
    Call<ValidationResponse> validateKey(@Query("action") String action);
    @POST("search_json")
    Call<ResponseBody> aml(@Query("data") String data, @Query("checks") String checks);

    @POST("/segment/v1/")
    @Multipart
    Call<AutoCrop> callAutoCrop(@Part("api_key") RequestBody apiKey, @Part("api_secret") RequestBody apiSecret, @Part MultipartBody.Part image);

    @FormUrlEncoded
    @POST("feature-check")
    Call<FeatureCheck> callFeatureCheck(@Field("uuid") String uuid);
    @FormUrlEncoded
    @POST("feature-check")
    Call<NashidFeatureCheck> callNashidFeatureCheck(@Field("uuid") String uuid);
    @FormUrlEncoded
    @POST("manage-feature")
    Call<NashidFeatureCheck> callManageFeature(@Field("features") String features,@Field("uuid") String uuid);
    @FormUrlEncoded
    @POST("nfc-status")
    Call<ResponseBody> callNFCStatus(@Field("uuid") String uuid);

    @FormUrlEncoded
    @POST("get-employee-token")
    Call<ResponseBody> callGetEmployeeToken(@Field("email") String email);

    @POST("upload-file")
    @Multipart
    Call<ResponseBody> callUploadFile(@Part("type") RequestBody apiKey, @Part MultipartBody.Part image);

    @FormUrlEncoded
    @POST("company-scans")
    Call<ResponseBody> callCompanyScans(@Field("scan_type") String scanType, @Field("uuid")String uuid,
                                        @Field("scan_data")String scandata,@Field("scan_status")int scanStatus
                                        ,@Field("scan_code")String scanCode,@Field("scan_time")String scanTime);

}
