/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.id_card.jmrtd;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import nashid.verify.sdk.id_card.jmrtd.APDULevelReadBinaryCapable;
import nashid.verify.sdk.id_card.jmrtd.io.FragmentBuffer;
import nashid.verify.sdk.id_card.jmrtd.lds.LDSFileUtil;
import net.sf.scuba.smartcards.APDUWrapper;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.FileInfo;
import net.sf.scuba.smartcards.FileSystemStructured;
import net.sf.scuba.tlv.TLVInputStream;

public class DefaultFileSystem
implements FileSystemStructured {
    public static final int NO_SFI = -1;
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    private static final int READ_AHEAD_LENGTH = 8;
    private short selectedFID;
    private final boolean isSFIEnabled;
    private boolean isSelected;
    private final APDULevelReadBinaryCapable service;
    private final Map<Short, DefaultFileInfo> fileInfos;
    private final Map<Short, Byte> fidToSFI;
    private APDUWrapper wrapper;

    public DefaultFileSystem(APDULevelReadBinaryCapable service, boolean isSFIEnabled) {
        this(service, isSFIEnabled, LDSFileUtil.FID_TO_SFI);
    }

    public DefaultFileSystem(APDULevelReadBinaryCapable service, boolean isSFIEnabled, Map<Short, Byte> fidToSFI) {
        this.service = service;
        this.fileInfos = new HashMap<Short, DefaultFileInfo>();
        this.selectedFID = 0;
        this.isSelected = false;
        this.isSFIEnabled = isSFIEnabled;
        this.fidToSFI = fidToSFI;
    }

    public void setWrapper(APDUWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public synchronized FileInfo[] getSelectedPath() throws CardServiceException {
        DefaultFileInfo fileInfo = this.getFileInfo();
        if (fileInfo == null) {
            return null;
        }
        return new DefaultFileInfo[]{fileInfo};
    }

    public synchronized void selectFile(short fid) throws CardServiceException {
        if (this.selectedFID == fid) {
            return;
        }
        this.selectedFID = fid;
        this.isSelected = false;
    }

    public synchronized byte[] readBinary(int offset, int length) throws CardServiceException {
        DefaultFileInfo fileInfo = null;
        try {
            if (this.selectedFID <= 0) {
                throw new CardServiceException("No file selected");
            }
            fileInfo = this.getFileInfo();
            if (fileInfo == null) {
                throw new IllegalStateException("Could not get file info");
            }
            FragmentBuffer.Fragment fragment = fileInfo.getSmallestUnbufferedFragment(offset, length);
            int responseLength = length;
            byte[] bytes = null;
            if (fragment.getLength() > 0) {
                if (this.isSFIEnabled && offset < 256) {
                    Byte sfi = this.fidToSFI.get(this.selectedFID);
                    if (sfi == null) {
                        throw new NumberFormatException("Unknown FID " + Integer.toHexString(this.selectedFID));
                    }
                    bytes = this.sendReadBinary(0x80 | sfi & 0xFF, fragment.getOffset(), fragment.getLength(), false);
                    this.isSelected = true;
                } else {
                    if (!this.isSelected) {
                        this.sendSelectFile(this.selectedFID);
                        this.isSelected = true;
                    }
                    bytes = this.sendReadBinary(fragment.getOffset(), fragment.getLength(), offset > Short.MAX_VALUE);
                }
                if (bytes == null) {
                    throw new IllegalStateException("Could not read bytes");
                }
                if (bytes.length > 0) {
                    fileInfo.addFragment(fragment.getOffset(), bytes);
                }
                responseLength = bytes.length;
            }
            byte[] buffer = fileInfo.getBuffer();
            byte[] result2 = new byte[responseLength];
            System.arraycopy(buffer, offset, result2, 0, responseLength);
            return result2;
        }
        catch (CardServiceException cse) {
            throw new CardServiceException("Read binary failed on file " + (fileInfo == null ? Integer.toHexString(this.selectedFID) : fileInfo), (Throwable)cse, cse.getSW());
        }
        catch (Exception e) {
            throw new CardServiceException("Read binary failed on file " + (fileInfo == null ? Integer.toHexString(this.selectedFID) : fileInfo), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized DefaultFileInfo getFileInfo() throws CardServiceException {
        DefaultFileInfo defaultFileInfo;
        if (this.selectedFID <= 0) {
            throw new CardServiceException("No file selected");
        }
        DefaultFileInfo fileInfo = this.fileInfos.get(this.selectedFID);
        if (fileInfo != null) {
            return fileInfo;
        }
        byte[] prefix = null;
        if (this.isSFIEnabled) {
            Byte sfi = this.fidToSFI.get(this.selectedFID);
            if (sfi == null) {
                throw new NumberFormatException("Unknown FID " + Integer.toHexString(this.selectedFID));
            }
            prefix = this.sendReadBinary(0x80 | sfi & 0xFF, 0, 8, false);
            this.isSelected = true;
        } else {
            if (!this.isSelected) {
                this.sendSelectFile(this.selectedFID);
                this.isSelected = true;
            }
            prefix = this.sendReadBinary(0, 8, false);
        }
        if (prefix == null || prefix.length != 8) {
            LOGGER.warning("Something is wrong with prefix, prefix = " + Arrays.toString(prefix));
            return null;
        }
        ByteArrayInputStream baInputStream = new ByteArrayInputStream(prefix);
        TLVInputStream tlvInputStream = new TLVInputStream((InputStream)baInputStream);
        try {
            int fileLength = 0;
            int tag = tlvInputStream.readTag();
            if (tag == 66) {
                fileLength = 36;
            } else {
                int vLength = tlvInputStream.readLength();
                int tlLength = prefix.length - baInputStream.available();
                fileLength = tlLength + vLength;
            }
            fileInfo = new DefaultFileInfo(this.selectedFID, fileLength);
            fileInfo.addFragment(0, prefix);
            this.fileInfos.put(this.selectedFID, fileInfo);
            defaultFileInfo = fileInfo;
        }
        catch (Throwable throwable) {
            try {
                tlvInputStream.close();
                throw throwable;
            }
            catch (IOException ioe) {
                throw new CardServiceException("Error getting file info for " + Integer.toHexString(this.selectedFID), (Throwable)ioe);
            }
        }
        tlvInputStream.close();
        return defaultFileInfo;
    }

    public synchronized void sendSelectFile(short fid) throws CardServiceException {
        this.service.sendSelectFile(this.wrapper, fid);
    }

    public synchronized byte[] sendReadBinary(int offset, int le, boolean isTLVEncodedOffsetNeeded) throws CardServiceException {
        return this.service.sendReadBinary(this.wrapper, -1, offset, le, false, isTLVEncodedOffsetNeeded);
    }

    public synchronized byte[] sendReadBinary(int sfi, int offset, int le, boolean isTLVEncodedOffsetNeeded) throws CardServiceException {
        return this.service.sendReadBinary(this.wrapper, sfi, offset, le, true, isTLVEncodedOffsetNeeded);
    }

    private static class DefaultFileInfo
    extends FileInfo
    implements Serializable {
        private static final long serialVersionUID = 6727369753765119839L;
        private final short fid;
        private final FragmentBuffer buffer;

        public DefaultFileInfo(short fid, int length) {
            this.fid = fid;
            this.buffer = new FragmentBuffer(length);
        }

        public byte[] getBuffer() {
            return this.buffer.getBuffer();
        }

        public short getFID() {
            return this.fid;
        }

        public int getFileLength() {
            return this.buffer.getLength();
        }

        public String toString() {
            return Integer.toHexString(this.fid);
        }

        public FragmentBuffer.Fragment getSmallestUnbufferedFragment(int offset, int length) {
            return this.buffer.getSmallestUnbufferedFragment(offset, length);
        }

        public void addFragment(int offset, byte[] bytes) {
            this.buffer.addFragment(offset, bytes);
        }
    }
}

