/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.id_card.jmrtd.cert;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import nashid.verify.sdk.id_card.jmrtd.cert.CVCAuthorizationTemplate;
import nashid.verify.sdk.id_card.jmrtd.cert.CVCPrincipal;
import net.sf.scuba.data.Country;
import org.ejbca.cvc.AccessRightEnum;
import org.ejbca.cvc.AlgorithmUtil;
import org.ejbca.cvc.AuthorizationRoleEnum;
import org.ejbca.cvc.CAReferenceField;
import org.ejbca.cvc.CVCPublicKey;
import org.ejbca.cvc.CVCertificate;
import org.ejbca.cvc.CVCertificateBody;
import org.ejbca.cvc.HolderReferenceField;
import org.ejbca.cvc.OIDField;
import org.ejbca.cvc.exception.ConstructionException;

public class CardVerifiableCertificate
extends Certificate {
    private static final long serialVersionUID = -3585440601605666288L;
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    private CVCertificate cvCertificate;
    private transient KeyFactory rsaKeyFactory;

    protected CardVerifiableCertificate(CVCertificate cvCertificate) {
        super("CVC");
        try {
            this.rsaKeyFactory = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException nsae) {
            LOGGER.log(Level.WARNING, "Exception", nsae);
        }
        this.cvCertificate = cvCertificate;
    }

    public CardVerifiableCertificate(CVCPrincipal authorityReference, CVCPrincipal holderReference, PublicKey publicKey, String algorithm, Date notBefore, Date notAfter, CVCAuthorizationTemplate.Role role, CVCAuthorizationTemplate.Permission permission2, byte[] signatureData) {
        this((CVCertificate)null);
        try {
            CAReferenceField authorityRef = new CAReferenceField(authorityReference.getCountry().toAlpha2Code(), authorityReference.getMnemonic(), authorityReference.getSeqNumber());
            HolderReferenceField holderRef = new HolderReferenceField(holderReference.getCountry().toAlpha2Code(), holderReference.getMnemonic(), holderReference.getSeqNumber());
            AuthorizationRoleEnum authRole = CVCAuthorizationTemplate.fromRole(role);
            AccessRightEnum accessRight = CVCAuthorizationTemplate.fromPermission(permission2);
            CVCertificateBody body = new CVCertificateBody(authorityRef, org.ejbca.cvc.KeyFactory.createInstance((PublicKey)publicKey, (String)algorithm, (AuthorizationRoleEnum)authRole), holderRef, authRole, accessRight, notBefore, notAfter);
            this.cvCertificate = new CVCertificate(body);
            this.cvCertificate.setSignature(signatureData);
            this.cvCertificate.getTBS();
        }
        catch (ConstructionException ce) {
            throw new IllegalArgumentException(ce);
        }
    }

    public String getSigAlgName() {
        try {
            OIDField oid = this.cvCertificate.getCertificateBody().getPublicKey().getObjectIdentifier();
            return AlgorithmUtil.getAlgorithmName((OIDField)oid);
        }
        catch (NoSuchFieldException nsfe) {
            LOGGER.log(Level.WARNING, "No such field", nsfe);
            return null;
        }
    }

    public String getSigAlgOID() {
        try {
            OIDField oid = this.cvCertificate.getCertificateBody().getPublicKey().getObjectIdentifier();
            return oid.getAsText();
        }
        catch (NoSuchFieldException nsfe) {
            LOGGER.log(Level.WARNING, "No such field", nsfe);
            return null;
        }
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            return this.cvCertificate.getDEREncoded();
        }
        catch (IOException ioe) {
            throw new CertificateEncodingException(ioe);
        }
    }

    @Override
    public PublicKey getPublicKey() {
        try {
            CVCPublicKey publicKey = this.cvCertificate.getCertificateBody().getPublicKey();
            if ("RSA".equals(publicKey.getAlgorithm())) {
                RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
                try {
                    return this.rsaKeyFactory.generatePublic(new RSAPublicKeySpec(rsaPublicKey.getModulus(), rsaPublicKey.getPublicExponent()));
                }
                catch (GeneralSecurityException gse) {
                    LOGGER.log(Level.WARNING, "Exception", gse);
                    return publicKey;
                }
            }
            return publicKey;
        }
        catch (NoSuchFieldException nsfe) {
            LOGGER.log(Level.WARNING, "No such field", nsfe);
            return null;
        }
    }

    @Override
    public String toString() {
        return this.cvCertificate.toString();
    }

    @Override
    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Provider[] providers = Security.getProviders();
        boolean foundProvider = false;
        for (Provider provider : providers) {
            try {
                this.cvCertificate.verify(key, provider.getName());
                foundProvider = true;
                break;
            }
            catch (NoSuchAlgorithmException nse) {
                LOGGER.log(Level.FINE, "Trying next provider", nse);
            }
        }
        if (!foundProvider) {
            throw new NoSuchAlgorithmException("Tried all security providers: None was able to provide this signature algorithm.");
        }
    }

    @Override
    public void verify(PublicKey key, String provider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.cvCertificate.verify(key, provider);
    }

    public byte[] getCertBodyData() throws CertificateException, IOException {
        try {
            return this.cvCertificate.getCertificateBody().getDEREncoded();
        }
        catch (NoSuchFieldException nsfe) {
            throw new CertificateException("No such field", nsfe);
        }
    }

    public Date getNotBefore() throws CertificateException {
        try {
            return this.cvCertificate.getCertificateBody().getValidFrom();
        }
        catch (NoSuchFieldException nsfe) {
            throw new CertificateException("No such field", nsfe);
        }
    }

    public Date getNotAfter() throws CertificateException {
        try {
            return this.cvCertificate.getCertificateBody().getValidTo();
        }
        catch (NoSuchFieldException nsfe) {
            throw new CertificateException("No such field", nsfe);
        }
    }

    public CVCPrincipal getAuthorityReference() throws CertificateException {
        try {
            CAReferenceField rf = this.cvCertificate.getCertificateBody().getAuthorityReference();
            String countryCode = rf.getCountry().toUpperCase();
            Country country = Country.getInstance((String)countryCode);
            return new CVCPrincipal(country, rf.getMnemonic(), rf.getSequence());
        }
        catch (NoSuchFieldException nsfe) {
            throw new CertificateException("No such field", nsfe);
        }
    }

    public CVCPrincipal getHolderReference() throws CertificateException {
        try {
            HolderReferenceField rf = this.cvCertificate.getCertificateBody().getHolderReference();
            return new CVCPrincipal(Country.getInstance((String)rf.getCountry().toUpperCase()), rf.getMnemonic(), rf.getSequence());
        }
        catch (NoSuchFieldException nsfe) {
            throw new CertificateException("No such field", nsfe);
        }
    }

    public CVCAuthorizationTemplate getAuthorizationTemplate() throws CertificateException {
        try {
            org.ejbca.cvc.CVCAuthorizationTemplate template = this.cvCertificate.getCertificateBody().getAuthorizationTemplate();
            return new CVCAuthorizationTemplate(template);
        }
        catch (NoSuchFieldException nsfe) {
            throw new CertificateException("No such field", nsfe);
        }
    }

    public byte[] getSignature() throws CertificateException {
        try {
            return this.cvCertificate.getSignature();
        }
        catch (NoSuchFieldException nsfe) {
            throw new CertificateException("No such field", nsfe);
        }
    }

    @Override
    public boolean equals(Object otherObj) {
        if (otherObj == null) {
            return false;
        }
        if (this == otherObj) {
            return true;
        }
        if (!this.getClass().equals(otherObj.getClass())) {
            return false;
        }
        return this.cvCertificate.equals(((CardVerifiableCertificate)otherObj).cvCertificate);
    }

    @Override
    public int hashCode() {
        return this.cvCertificate.hashCode() * 2 - 1030507011;
    }
}

