/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.id_card.jmrtd.lds.icao;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import nashid.verify.sdk.id_card.jmrtd.Util;
import nashid.verify.sdk.id_card.jmrtd.lds.DataGroup;

public class DG15File
extends DataGroup {
    private static final long serialVersionUID = 3834304239673755744L;
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    private static final String[] PUBLIC_KEY_ALGORITHMS = new String[]{"RSA", "EC"};
    private PublicKey publicKey;

    public DG15File(PublicKey publicKey) {
        super(111);
        this.publicKey = publicKey;
    }

    public DG15File(InputStream inputStream) throws IOException {
        super(111, inputStream);
    }

    @Override
    protected void readContent(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        try {
            byte[] value = new byte[this.getLength()];
            dataInputStream.readFully(value);
            this.publicKey = DG15File.getPublicKey(value);
        }
        catch (GeneralSecurityException e) {
            LOGGER.log(Level.WARNING, "Unexpected exception while reading DG15 content", e);
        }
    }

    private static PublicKey getPublicKey(byte[] keyBytes) throws GeneralSecurityException {
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(keyBytes);
        for (String algorithm : PUBLIC_KEY_ALGORITHMS) {
            try {
                return Util.getPublicKey(algorithm, pubKeySpec);
            }
            catch (InvalidKeySpecException ikse) {
                LOGGER.log(Level.FINE, "Ignore, try next algorithm", ikse);
            }
        }
        throw new InvalidAlgorithmParameterException();
    }

    @Override
    protected void writeContent(OutputStream out) throws IOException {
        out.write(this.publicKey.getEncoded());
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DG15File other = (DG15File)obj;
        return this.publicKey.equals(other.publicKey);
    }

    public int hashCode() {
        return 5 * this.publicKey.hashCode() + 61;
    }

    @Override
    public String toString() {
        return "DG15File [" + Util.getDetailedPublicKeyAlgorithm(this.publicKey) + "]";
    }
}

