/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.id_card.jmrtd.lds.iso19794;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Logger;
import nashid.verify.sdk.id_card.jmrtd.cbeff.BiometricDataBlock;
import nashid.verify.sdk.id_card.jmrtd.cbeff.StandardBiometricHeader;
import nashid.verify.sdk.id_card.jmrtd.lds.AbstractListInfo;
import nashid.verify.sdk.id_card.jmrtd.lds.iso19794.FaceImageInfo;

public class FaceInfo
extends AbstractListInfo<FaceImageInfo>
implements BiometricDataBlock {
    private static final long serialVersionUID = -6053206262773400725L;
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    private static final int FORMAT_IDENTIFIER = 1178682112;
    private static final int VERSION_NUMBER = 0x30313000;
    private static final int FORMAT_OWNER_VALUE = 257;
    private static final int FORMAT_TYPE_VALUE = 8;
    private StandardBiometricHeader sbh;

    public FaceInfo(List<FaceImageInfo> faceImageInfos) {
        this(null, faceImageInfos);
    }

    public FaceInfo(StandardBiometricHeader sbh, List<FaceImageInfo> faceImageInfos) {
        this.sbh = sbh;
        this.addAll(faceImageInfos);
    }

    public FaceInfo(InputStream inputStream) throws IOException {
        this(null, inputStream);
    }

    public FaceInfo(StandardBiometricHeader sbh, InputStream inputStream) throws IOException {
        this.sbh = sbh;
        this.readObject(inputStream);
    }

    @Override
    public void readObject(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        int fac0 = dataInputStream.readInt();
        if (fac0 != 1178682112) {
            throw new IllegalArgumentException("'FAC' marker expected! Found " + Integer.toHexString(fac0));
        }
        int version = dataInputStream.readInt();
        if (version != 0x30313000) {
            throw new IllegalArgumentException("'010' version number expected! Found " + Integer.toHexString(version));
        }
        long recordLength = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
        long headerLength = 14L;
        long dataLength = recordLength - headerLength;
        long constructedDataLength = 0L;
        int count = dataInputStream.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            FaceImageInfo imageInfo = new FaceImageInfo(inputStream);
            constructedDataLength += imageInfo.getRecordLength();
            this.add(imageInfo);
        }
        if (dataLength != constructedDataLength) {
            LOGGER.warning("ConstructedDataLength and dataLength differ: dataLength = " + dataLength + ", constructedDataLength = " + constructedDataLength);
        }
    }

    @Override
    public void writeObject(OutputStream outputStream) throws IOException {
        int headerLength = 14;
        long dataLength = 0L;
        List faceImageInfos = this.getSubRecords();
        for (FaceImageInfo faceImageInfo : faceImageInfos) {
            dataLength += faceImageInfo.getRecordLength();
        }
        long recordLength = (long)headerLength + dataLength;
        DataOutputStream dataOut = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
        dataOut.writeInt(1178682112);
        dataOut.writeInt(0x30313000);
        dataOut.writeInt((int)(recordLength & 0xFFFFFFFFL));
        dataOut.writeShort(faceImageInfos.size());
        for (FaceImageInfo faceImageInfo : faceImageInfos) {
            faceImageInfo.writeObject(dataOut);
        }
    }

    @Override
    public StandardBiometricHeader getStandardBiometricHeader() {
        if (this.sbh == null) {
            byte[] biometricType = new byte[]{2};
            byte[] biometricSubtype = new byte[]{0};
            byte[] formatOwner = new byte[]{1, 1};
            byte[] formatType = new byte[]{0, 8};
            TreeMap<Integer, byte[]> elements = new TreeMap<Integer, byte[]>();
            elements.put(129, biometricType);
            elements.put(130, biometricSubtype);
            elements.put(135, formatOwner);
            elements.put(136, formatType);
            this.sbh = new StandardBiometricHeader(elements);
        }
        return this.sbh;
    }

    public List<FaceImageInfo> getFaceImageInfos() {
        return this.getSubRecords();
    }

    public void addFaceImageInfo(FaceImageInfo faceImageInfo) {
        this.add(faceImageInfo);
    }

    public void removeFaceImageInfo(int index) {
        this.remove(index);
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append("FaceInfo [");
        List records = this.getSubRecords();
        for (FaceImageInfo record : records) {
            result2.append(record.toString());
        }
        result2.append("]");
        return result2.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.sbh == null ? 0 : this.sbh.hashCode());
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FaceInfo other = (FaceInfo)obj;
        if (this.sbh == null) {
            return other.sbh == null;
        }
        return this.sbh == other.sbh || this.sbh.equals(other.sbh);
    }
}

