/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.id_card.jmrtd.protocol;

import java.util.logging.Level;
import java.util.logging.Logger;
import nashid.verify.sdk.id_card.jmrtd.APDULevelAACapable;
import nashid.verify.sdk.id_card.jmrtd.protocol.SecureMessagingAPDUSender;
import net.sf.scuba.smartcards.APDUWrapper;
import net.sf.scuba.smartcards.CardService;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.CommandAPDU;
import net.sf.scuba.smartcards.ResponseAPDU;
import net.sf.scuba.util.Hex;

public class AAAPDUSender
implements APDULevelAACapable {
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd.protocol");
    private final SecureMessagingAPDUSender secureMessagingSender;

    public AAAPDUSender(CardService service) {
        this.secureMessagingSender = new SecureMessagingAPDUSender(service);
    }

    @Override
    public synchronized byte[] sendInternalAuthenticate(APDUWrapper wrapper, byte[] rndIFD) throws CardServiceException {
        if (rndIFD == null || rndIFD.length != 8) {
            throw new IllegalArgumentException("rndIFD wrong length");
        }
        CommandAPDU capdu = new CommandAPDU(0, -120, 0, 0, rndIFD, 256);
        ResponseAPDU rapdu = null;
        int sw = -1;
        try {
            rapdu = this.secureMessagingSender.transmit(wrapper, capdu);
            sw = (short)rapdu.getSW();
        }
        catch (CardServiceException cse) {
            LOGGER.log(Level.INFO, "Exception during transmission of capdu = " + Hex.bytesToHexString((byte[])capdu.getBytes()), cse);
            sw = (short)cse.getSW();
        }
        if (sw == -28672 && rapdu != null) {
            return rapdu.getData();
        }
        if ((sw & 0xFF00) == 24832) {
            byte[] extendedLengthResponse;
            byte[] normalLengthResponse = rapdu == null ? null : rapdu.getData();
            capdu = new CommandAPDU(0, -120, 0, 0, rndIFD, 65536);
            rapdu = this.secureMessagingSender.transmit(wrapper, capdu);
            byte[] byArray = extendedLengthResponse = rapdu == null ? null : rapdu.getData();
            if (normalLengthResponse == null && extendedLengthResponse == null) {
                throw new CardServiceException("Internal Authenticate failed", sw);
            }
            if (normalLengthResponse != null && extendedLengthResponse == null) {
                return normalLengthResponse;
            }
            if (normalLengthResponse == null && extendedLengthResponse != null) {
                return extendedLengthResponse;
            }
            if (normalLengthResponse.length > extendedLengthResponse.length) {
                return normalLengthResponse;
            }
            return extendedLengthResponse;
        }
        if (rapdu != null && rapdu.getData() != null) {
            LOGGER.warning("Internal Authenticate may not have succeeded, got status word " + Integer.toHexString(sw & 0xFFFF));
            return rapdu.getData();
        }
        throw new CardServiceException("Internal Authenticate failed", sw);
    }
}

