/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.mrtd2.BitiMRTD.Tools;

import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import nashid.verify.sdk.mrtd2.BitiMRTD.Tools.AESCMAC;
import nashid.verify.sdk.mrtd2.BitiMRTD.Tools.Tools;

public class Crypto {
    protected byte[] ivValue = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    protected byte[] C1 = new byte[]{0, 0, 0, 1};
    protected byte[] C2 = new byte[]{0, 0, 0, 2};
    protected Tools tools = new Tools();

    public byte[] generateRandomBytes(int size) {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[size];
        random.nextBytes(bytes);
        return bytes;
    }

    public byte[] calculateSeed(String passportNbr, String dateOfBirth, String dateOfExpiration) {
        String mrz = "";
        mrz = mrz.concat(passportNbr);
        mrz = mrz.concat(String.valueOf(this.tools.calculateMrzCheckDigit(passportNbr)));
        mrz = mrz.concat(dateOfBirth);
        mrz = mrz.concat(String.valueOf(this.tools.calculateMrzCheckDigit(dateOfBirth)));
        mrz = mrz.concat(dateOfExpiration);
        mrz = mrz.concat(String.valueOf(this.tools.calculateMrzCheckDigit(dateOfExpiration)));
        return Arrays.copyOfRange(this.sha1(mrz.getBytes()), 0, 16);
    }

    public byte[] calculateMacKey(byte[] seed) {
        byte[] macKey = this.tools.adjustParityBits(Arrays.copyOfRange(this.sha1(this.tools.concatByteArrays(seed, this.C2)), 0, 16));
        System.out.println("MacKey : ".concat(this.tools.bytesToString(macKey)));
        return macKey;
    }

    public byte[] sha1(byte[] input) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(input);
            return md.digest();
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
            }
            return null;
        }
    }

    public byte[] padData(byte[] data, int padSize) {
        byte[] result2 = this.tools.concatByteArrays(data, this.tools.byteToBytes((byte)-128));
        while (result2.length % padSize != 0) {
            result2 = this.tools.concatByteArrays(result2, this.tools.byteToBytes((byte)0));
        }
        return result2;
    }

    public byte[] calculate3DESEncryptionKey(byte[] seed) {
        byte[] encKey16Bytes = this.tools.adjustParityBits(Arrays.copyOfRange(this.sha1(this.tools.concatByteArrays(seed, this.C1)), 0, 16));
        byte[] encKey24Bytes = this.tools.concatByteArrays(encKey16Bytes, Arrays.copyOfRange(encKey16Bytes, 0, 8));
        System.out.println("EncKey 16 Bytes : ".concat(this.tools.bytesToString(encKey16Bytes)));
        System.out.println("EncKey 24 Bytes : ".concat(this.tools.bytesToString(encKey24Bytes)));
        return encKey24Bytes;
    }

    public byte[] calculateAESEncryptionKey(byte[] seed) {
        return this.tools.adjustParityBits(Arrays.copyOfRange(this.sha1(this.tools.concatByteArrays(seed, this.C1)), 0, 16));
    }

    public byte[] encryptUsingDES(byte[] key, byte[] payload) {
        try {
            SecretKeySpec sKey = new SecretKeySpec(key, "AES");
            IvParameterSpec iv = new IvParameterSpec(this.ivValue);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)sKey, iv);
            return cipher.doFinal(payload);
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
            }
            return null;
        }
    }

    public byte[] decryptUsingDES(byte[] key, byte[] payload) {
        try {
            SecretKeySpec sKey = new SecretKeySpec(key, "AES");
            IvParameterSpec iv = new IvParameterSpec(this.ivValue);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)sKey, iv);
            return cipher.doFinal(payload);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public byte[] calculate3DESMac(byte[] macKey, byte[] message, boolean addPad) {
        byte[] key1 = Arrays.copyOfRange(macKey, 0, 8);
        byte[] key2 = Arrays.copyOfRange(macKey, 8, 16);
        if (addPad) {
            message = this.padData(message, 8);
        }
        byte[] hq = this.encryptUsingDES(key1, Arrays.copyOfRange(message, 0, 8));
        int i = 8;
        while (i + 8 <= message.length) {
            hq = this.tools.doXor(hq, Arrays.copyOfRange(message, i, i + 8));
            hq = this.encryptUsingDES(key1, hq);
            i += 8;
        }
        return this.encryptUsingDES(key1, this.decryptUsingDES(key2, hq));
    }

    public byte[] calculateAESMac(byte[] macKey, byte[] message, boolean addPad) {
        return Arrays.copyOfRange(AESCMAC.get(macKey, message), 0, 8);
    }

    public byte[] encrypt3DES(byte[] key, byte[] payload) {
        try {
            SecretKeySpec sKey = new SecretKeySpec(key, "AES");
            IvParameterSpec iv = new IvParameterSpec(this.ivValue);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)sKey, iv);
            return cipher.doFinal(payload);
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
            }
            return null;
        }
    }

    public byte[] encryptAES(byte[] key, byte[] payload) {
        try {
            SecretKeySpec sKey = new SecretKeySpec(key, "AES");
            IvParameterSpec iv = new IvParameterSpec(this.ivValue);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)sKey, iv);
            return cipher.doFinal(payload);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public byte[] decrypt3DES(byte[] key, byte[] payload) {
        try {
            SecretKeySpec sKey = new SecretKeySpec(key, "AES");
            IvParameterSpec iv = new IvParameterSpec(this.ivValue);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)sKey, iv);
            return cipher.doFinal(payload);
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
            }
            return null;
        }
    }

    public byte[] decryptAES(byte[] key, byte[] payload) {
        try {
            SecretKeySpec sKey = new SecretKeySpec(key, "AES");
            IvParameterSpec iv = new IvParameterSpec(this.ivValue);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)sKey, iv);
            return cipher.doFinal(payload);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }
}

