/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.mrtd2.activity;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.fragment.app.FragmentActivity;
import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nashid.verify.sdk.NashidSDK;
import nashid.verify.sdk.R;
import nashid.verify.sdk.databinding.ActivitySdkSettingBinding;
import nashid.verify.sdk.internetutility.ErrorUtility;
import nashid.verify.sdk.mrtd2.activity.BaseActivity;
import nashid.verify.sdk.mrtd2.activity.TextSizeConverter;
import nashid.verify.sdk.mrtd2.rooted.RootedCheck;
import nashid.verify.sdk.networking.APIClient;
import nashid.verify.sdk.networking.APIInterface;
import nashid.verify.sdk.networking.models.nashidfeaturecheck.NashidFeatureCheck;
import nashid.verify.sdk.utility.SharePreferenceUtility;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\b\u0010\u000f\u001a\u00020\rH\u0002J\b\u0010\u0010\u001a\u00020\rH\u0002J\u0014\u0010\u0011\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\rH\u0002J\b\u0010\u0018\u001a\u00020\rH\u0016J\u0012\u0010\u0019\u001a\u00020\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J\b\u0010\u001c\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lnashid/verify/sdk/mrtd2/activity/SDKSettingScreen;", "Lnashid/verify/sdk/mrtd2/activity/BaseActivity;", "()V", "binding", "Lnashid/verify/sdk/databinding/ActivitySdkSettingBinding;", "currentCall", "Lretrofit2/Call;", "Lnashid/verify/sdk/networking/models/nashidfeaturecheck/NashidFeatureCheck;", "isApiCalled", "", "lastSelectedFeature", "", "callManageFeatureAPI", "", "features", "callNashidFeatureCheckAPI", "deSelectAll", "determineFeature", "", "handleClickofSelection", "selectedOption", "imageview", "Landroid/widget/ImageView;", "initClick", "onAvailable", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "setLayoutAndTextSize", "Companion", "IDV_release"})
public final class SDKSettingScreen
extends BaseActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private ActivitySdkSettingBinding binding;
    private String lastSelectedFeature;
    @Nullable
    private Call<NashidFeatureCheck> currentCall;
    private boolean isApiCalled;
    @NotNull
    public static final String SCAN = "Scan";
    @NotNull
    public static final String NFC = "NFC";
    @NotNull
    public static final String FACEMATCH = "Face-Match";
    @NotNull
    public static final String LIVENESS = "Liveness";

    @Override
    public void onAvailable() {
        Log.d((String)"SDKSetting", (String)"onAvailable: ");
        this.runOnUiThread(() -> SDKSettingScreen.onAvailable$lambda$0(this));
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ActivitySdkSettingBinding activitySdkSettingBinding = ActivitySdkSettingBinding.inflate(this.getLayoutInflater());
        Intrinsics.checkNotNullExpressionValue((Object)activitySdkSettingBinding, (String)"inflate(...)");
        this.binding = activitySdkSettingBinding;
        ActivitySdkSettingBinding activitySdkSettingBinding2 = this.binding;
        if (activitySdkSettingBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding2 = null;
        }
        this.setContentView((View)activitySdkSettingBinding2.getRoot());
        RootedCheck.getInstance().setFlag((Activity)this);
        if (RootedCheck.getInstance().isRootedDevice(this.getApplicationContext())) {
            RootedCheck.getInstance().showRootedDeviceDialog((Activity)this, this.getString(R.string.root_dialog), this.getString(R.string.root_desc), this.getString(R.string.root_btn));
        } else {
            this.setLayoutAndTextSize();
            this.callNashidFeatureCheckAPI();
            this.initClick();
        }
    }

    private final void deSelectAll() {
        ActivitySdkSettingBinding activitySdkSettingBinding = this.binding;
        if (activitySdkSettingBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding = null;
        }
        activitySdkSettingBinding.imgScan.setImageResource(R.drawable.radio_off);
        ActivitySdkSettingBinding activitySdkSettingBinding2 = this.binding;
        if (activitySdkSettingBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding2 = null;
        }
        activitySdkSettingBinding2.imgScanNfc.setImageResource(R.drawable.radio_off);
        ActivitySdkSettingBinding activitySdkSettingBinding3 = this.binding;
        if (activitySdkSettingBinding3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding3 = null;
        }
        activitySdkSettingBinding3.imgScanLiveness.setImageResource(R.drawable.radio_off);
        ActivitySdkSettingBinding activitySdkSettingBinding4 = this.binding;
        if (activitySdkSettingBinding4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding4 = null;
        }
        activitySdkSettingBinding4.imgScanNfcLiveness.setImageResource(R.drawable.radio_off);
    }

    public final void determineFeature(@NotNull List<String> features) {
        Intrinsics.checkNotNullParameter(features, (String)"features");
        Object[] objectArray = new List[8];
        Object[] objectArray2 = new String[]{SCAN, NFC, LIVENESS, FACEMATCH};
        objectArray[0] = ArraysKt.toList((Object[])objectArray2);
        objectArray2 = new String[]{SCAN, NFC, LIVENESS};
        objectArray[1] = ArraysKt.toList((Object[])objectArray2);
        objectArray2 = new String[]{SCAN, NFC, FACEMATCH};
        objectArray[2] = ArraysKt.toList((Object[])objectArray2);
        objectArray2 = new String[]{SCAN, NFC};
        objectArray[3] = ArraysKt.toList((Object[])objectArray2);
        objectArray2 = new String[]{SCAN, LIVENESS, FACEMATCH};
        objectArray[4] = ArraysKt.toList((Object[])objectArray2);
        objectArray2 = new String[]{SCAN, LIVENESS};
        objectArray[5] = ArraysKt.toList((Object[])objectArray2);
        objectArray2 = new String[]{SCAN, FACEMATCH};
        objectArray[6] = ArraysKt.toList((Object[])objectArray2);
        objectArray2 = new String[]{SCAN};
        objectArray[7] = ArraysKt.toList((Object[])objectArray2);
        List combinations = CollectionsKt.listOf((Object[])objectArray);
        objectArray2 = new Pair[8];
        Object[] objectArray3 = new String[]{SCAN, NFC, LIVENESS, FACEMATCH};
        objectArray2[0] = TuplesKt.to((Object)ArraysKt.toList((Object[])objectArray3), (Object)new Pair((Object)true, (Object)true));
        objectArray3 = new String[]{SCAN, NFC, LIVENESS};
        objectArray2[1] = TuplesKt.to((Object)ArraysKt.toList((Object[])objectArray3), (Object)new Pair((Object)true, (Object)true));
        objectArray3 = new String[]{SCAN, NFC, FACEMATCH};
        objectArray2[2] = TuplesKt.to((Object)ArraysKt.toList((Object[])objectArray3), (Object)new Pair((Object)true, (Object)true));
        objectArray3 = new String[]{SCAN, NFC};
        objectArray2[3] = TuplesKt.to((Object)ArraysKt.toList((Object[])objectArray3), (Object)new Pair((Object)true, (Object)false));
        objectArray3 = new String[]{SCAN, LIVENESS, FACEMATCH};
        objectArray2[4] = TuplesKt.to((Object)ArraysKt.toList((Object[])objectArray3), (Object)new Pair((Object)false, (Object)true));
        objectArray3 = new String[]{SCAN, LIVENESS};
        objectArray2[5] = TuplesKt.to((Object)ArraysKt.toList((Object[])objectArray3), (Object)new Pair((Object)false, (Object)true));
        objectArray3 = new String[]{SCAN, FACEMATCH};
        objectArray2[6] = TuplesKt.to((Object)ArraysKt.toList((Object[])objectArray3), (Object)new Pair((Object)false, (Object)true));
        objectArray3 = new String[]{SCAN};
        objectArray2[7] = TuplesKt.to((Object)ArraysKt.toList((Object[])objectArray3), (Object)new Pair((Object)false, (Object)false));
        Map preferences = MapsKt.mapOf((Pair[])objectArray2);
        objectArray3 = new Pair[8];
        Object object = new String[]{SCAN, NFC, LIVENESS, FACEMATCH};
        List list = ArraysKt.toList((Object[])object);
        ActivitySdkSettingBinding activitySdkSettingBinding = this.binding;
        if (activitySdkSettingBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding = null;
        }
        objectArray3[0] = TuplesKt.to((Object)list, (Object)activitySdkSettingBinding.imgScanNfcLiveness);
        object = new String[]{SCAN, NFC, LIVENESS};
        List list2 = ArraysKt.toList((Object[])object);
        ActivitySdkSettingBinding activitySdkSettingBinding2 = this.binding;
        if (activitySdkSettingBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding2 = null;
        }
        objectArray3[1] = TuplesKt.to((Object)list2, (Object)activitySdkSettingBinding2.imgScanNfcLiveness);
        object = new String[]{SCAN, NFC, FACEMATCH};
        List list3 = ArraysKt.toList((Object[])object);
        ActivitySdkSettingBinding activitySdkSettingBinding3 = this.binding;
        if (activitySdkSettingBinding3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding3 = null;
        }
        objectArray3[2] = TuplesKt.to((Object)list3, (Object)activitySdkSettingBinding3.imgScanNfcLiveness);
        object = new String[]{SCAN, NFC};
        List list4 = ArraysKt.toList((Object[])object);
        ActivitySdkSettingBinding activitySdkSettingBinding4 = this.binding;
        if (activitySdkSettingBinding4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding4 = null;
        }
        objectArray3[3] = TuplesKt.to((Object)list4, (Object)activitySdkSettingBinding4.imgScanNfc);
        object = new String[]{SCAN, LIVENESS, FACEMATCH};
        List list5 = ArraysKt.toList((Object[])object);
        ActivitySdkSettingBinding activitySdkSettingBinding5 = this.binding;
        if (activitySdkSettingBinding5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding5 = null;
        }
        objectArray3[4] = TuplesKt.to((Object)list5, (Object)activitySdkSettingBinding5.imgScanLiveness);
        object = new String[]{SCAN, LIVENESS};
        List list6 = ArraysKt.toList((Object[])object);
        ActivitySdkSettingBinding activitySdkSettingBinding6 = this.binding;
        if (activitySdkSettingBinding6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding6 = null;
        }
        objectArray3[5] = TuplesKt.to((Object)list6, (Object)activitySdkSettingBinding6.imgScanLiveness);
        object = new String[]{SCAN, FACEMATCH};
        List list7 = ArraysKt.toList((Object[])object);
        ActivitySdkSettingBinding activitySdkSettingBinding7 = this.binding;
        if (activitySdkSettingBinding7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding7 = null;
        }
        objectArray3[6] = TuplesKt.to((Object)list7, (Object)activitySdkSettingBinding7.imgScanLiveness);
        object = new String[]{SCAN};
        List list8 = ArraysKt.toList((Object[])object);
        ActivitySdkSettingBinding activitySdkSettingBinding8 = this.binding;
        if (activitySdkSettingBinding8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding8 = null;
        }
        objectArray3[7] = TuplesKt.to((Object)list8, (Object)activitySdkSettingBinding8.imgScan);
        Map imageResources = MapsKt.mapOf((Pair[])objectArray3);
        object = new Pair[8];
        Object[] objectArray4 = new String[]{SCAN, NFC, LIVENESS, FACEMATCH};
        object[0] = TuplesKt.to((Object)ArraysKt.toList((Object[])objectArray4), (Object)"Scan,NFC,Liveness,Face-Match");
        objectArray4 = new String[]{SCAN, NFC, LIVENESS};
        object[1] = TuplesKt.to((Object)ArraysKt.toList((Object[])objectArray4), (Object)"Scan,NFC,Liveness");
        objectArray4 = new String[]{SCAN, NFC, FACEMATCH};
        object[2] = TuplesKt.to((Object)ArraysKt.toList((Object[])objectArray4), (Object)"Scan,NFC,Face-Match");
        objectArray4 = new String[]{SCAN, NFC};
        object[3] = TuplesKt.to((Object)ArraysKt.toList((Object[])objectArray4), (Object)"Scan,NFC");
        objectArray4 = new String[]{SCAN, LIVENESS, FACEMATCH};
        object[4] = TuplesKt.to((Object)ArraysKt.toList((Object[])objectArray4), (Object)"Scan,Liveness,Face-Match");
        objectArray4 = new String[]{SCAN, LIVENESS};
        object[5] = TuplesKt.to((Object)ArraysKt.toList((Object[])objectArray4), (Object)"Scan,Liveness");
        objectArray4 = new String[]{SCAN, FACEMATCH};
        object[6] = TuplesKt.to((Object)ArraysKt.toList((Object[])objectArray4), (Object)"Scan,Face-Match");
        objectArray4 = new String[]{SCAN};
        object[7] = TuplesKt.to((Object)ArraysKt.toList((Object[])objectArray4), (Object)SCAN);
        Map selectedFeature = MapsKt.mapOf((Pair[])object);
        for (List combination : combinations) {
            Log.d((String)"TAG", (String)("determineFeature: " + combination + "  " + features));
            if (!features.containsAll(combination)) continue;
            this.deSelectAll();
            ImageView imageView = (ImageView)imageResources.get(combination);
            if (imageView != null) {
                imageView.setImageResource(R.drawable.radio_on);
            }
            this.lastSelectedFeature = String.valueOf(selectedFeature.get(combination));
            Pair pair = (Pair)preferences.get(combination);
            if (pair == null) {
                pair = new Pair((Object)false, (Object)false);
            }
            Pair preference = pair;
            SharePreferenceUtility.savePreferenceValue(this.getApplicationContext(), this.getString(R.string.sharepreference_nfc), (Boolean)preference.getFirst());
            SharePreferenceUtility.savePreferenceValue(this.getApplicationContext(), this.getString(R.string.sharepreference_facila_matching), (Boolean)preference.getSecond());
            return;
        }
    }

    private final void callNashidFeatureCheckAPI() {
        if (!this.isInternetAvailable()) {
            ErrorUtility.getInstance().showNoInternetDialog((FragmentActivity)this, !this.isFinishing() && !this.isDestroyed());
        } else {
            ActivitySdkSettingBinding activitySdkSettingBinding = this.binding;
            if (activitySdkSettingBinding == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                activitySdkSettingBinding = null;
            }
            activitySdkSettingBinding.lytLoading.setVisibility(0);
            Log.d((String)"TAG", (String)("callNashidFeatureCheckAPI: " + NashidSDK.Companion.getInstance().getBaseURL()));
            if (!StringsKt.equals((String)NashidSDK.Companion.getInstance().getBaseURL(), (String)"", (boolean)true) && !StringsKt.equals((String)NashidSDK.Companion.getInstance().getRegisterToken(), (String)"", (boolean)true)) {
                ((APIInterface)APIClient.getNashidFeatureCheckClient(NashidSDK.Companion.getInstance().getBaseURL(), NashidSDK.Companion.getInstance().getRegisterToken()).create(APIInterface.class)).callNashidFeatureCheck(NashidSDK.Companion.getInstance().getCompanyUUID()).enqueue((Callback)new Callback<NashidFeatureCheck>(this){
                    final /* synthetic */ SDKSettingScreen this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onResponse(@NotNull Call<NashidFeatureCheck> call, @NotNull Response<NashidFeatureCheck> response) {
                        ActivitySdkSettingBinding activitySdkSettingBinding;
                        Intrinsics.checkNotNullParameter(call, (String)"call");
                        Intrinsics.checkNotNullParameter(response, (String)"response");
                        Log.d((String)"TAG", (String)StringsKt.trimIndent((String)("\n                                    openScanDocumentScreen onResponse: " + response.isSuccessful() + "\n                                    " + response.body() + "\n                                    ")));
                        try {
                            if (response.isSuccessful()) {
                                NashidFeatureCheck featureCheck;
                                SDKSettingScreen.access$setApiCalled$p(this.this$0, true);
                                NashidFeatureCheck nashidFeatureCheck = featureCheck = (NashidFeatureCheck)response.body();
                                Intrinsics.checkNotNull((Object)nashidFeatureCheck);
                                ArrayList<String> allFeature = nashidFeatureCheck.getData().getAllFeatures();
                                ArrayList<String> features = featureCheck.getData().getFeatures();
                                Log.d((String)"TAG", (String)("onResponse:featurecheck " + features + "\n" + allFeature));
                                Intrinsics.checkNotNull(features);
                                this.this$0.determineFeature((List<String>)features);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if ((activitySdkSettingBinding = SDKSettingScreen.access$getBinding$p(this.this$0)) == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                            activitySdkSettingBinding = null;
                        }
                        activitySdkSettingBinding.lytLoading.setVisibility(8);
                    }

                    public void onFailure(@NotNull Call<NashidFeatureCheck> call, @NotNull Throwable t) {
                        Intrinsics.checkNotNullParameter(call, (String)"call");
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        ActivitySdkSettingBinding activitySdkSettingBinding = SDKSettingScreen.access$getBinding$p(this.this$0);
                        if (activitySdkSettingBinding == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                            activitySdkSettingBinding = null;
                        }
                        activitySdkSettingBinding.lytLoading.setVisibility(8);
                        Log.d((String)"TAG", (String)("openScanDocumentScreen onFailure: " + t));
                    }
                });
            } else {
                ActivitySdkSettingBinding activitySdkSettingBinding2 = this.binding;
                if (activitySdkSettingBinding2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                    activitySdkSettingBinding2 = null;
                }
                activitySdkSettingBinding2.lytLoading.setVisibility(8);
            }
        }
    }

    private final void callManageFeatureAPI(String features) {
        Log.d((String)"TAG", (String)("callNashidFeatureCheckAPI: " + NashidSDK.Companion.getInstance().getBaseURL()));
        if (!StringsKt.equals((String)NashidSDK.Companion.getInstance().getBaseURL(), (String)"", (boolean)true) && !StringsKt.equals((String)NashidSDK.Companion.getInstance().getRegisterToken(), (String)"", (boolean)true)) {
            Call<NashidFeatureCheck> call = this.currentCall;
            if (call != null) {
                call.cancel();
            }
            Call<NashidFeatureCheck> call2 = this.currentCall = ((APIInterface)APIClient.getNashidFeatureCheckClient(NashidSDK.Companion.getInstance().getBaseURL(), NashidSDK.Companion.getInstance().getRegisterToken()).create(APIInterface.class)).callManageFeature(features, NashidSDK.Companion.getInstance().getCompanyUUID());
            if (call2 != null) {
                call2.enqueue((Callback)new Callback<NashidFeatureCheck>(){

                    public void onResponse(@NotNull Call<NashidFeatureCheck> call, @NotNull Response<NashidFeatureCheck> response) {
                        Intrinsics.checkNotNullParameter(call, (String)"call");
                        Intrinsics.checkNotNullParameter(response, (String)"response");
                        Log.d((String)"TAG", (String)StringsKt.trimIndent((String)("\n                            callNashidFeatureCheckAPIopenScanDocumentScreen onResponse: " + response.isSuccessful() + "\n                            " + response.body() + "\n                            ")));
                        try {
                            if (response.isSuccessful()) {
                                NashidFeatureCheck featureCheck;
                                NashidFeatureCheck nashidFeatureCheck = featureCheck = (NashidFeatureCheck)response.body();
                                Intrinsics.checkNotNull((Object)nashidFeatureCheck);
                                ArrayList<String> allFeature = nashidFeatureCheck.getData().getAllFeatures();
                                ArrayList<String> feature = featureCheck.getData().getFeatures();
                                Log.d((String)"TAG", (String)("onResponse:managefeature " + feature + "\n" + allFeature));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }

                    public void onFailure(@NotNull Call<NashidFeatureCheck> call, @NotNull Throwable t) {
                        Intrinsics.checkNotNullParameter(call, (String)"call");
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        Log.d((String)"TAG", (String)("openScanDocumentScreen onFailure: " + t));
                    }
                });
            }
        } else {
            ActivitySdkSettingBinding activitySdkSettingBinding = this.binding;
            if (activitySdkSettingBinding == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                activitySdkSettingBinding = null;
            }
            activitySdkSettingBinding.lytLoading.setVisibility(8);
            this.finish();
        }
    }

    private final void initClick() {
        ActivitySdkSettingBinding activitySdkSettingBinding = this.binding;
        if (activitySdkSettingBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding = null;
        }
        activitySdkSettingBinding.lytHeaderMain.imgBack.setOnClickListener(arg_0 -> SDKSettingScreen.initClick$lambda$1(this, arg_0));
        ActivitySdkSettingBinding activitySdkSettingBinding2 = this.binding;
        if (activitySdkSettingBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding2 = null;
        }
        activitySdkSettingBinding2.lytScan.setOnClickListener(arg_0 -> SDKSettingScreen.initClick$lambda$2(this, arg_0));
        ActivitySdkSettingBinding activitySdkSettingBinding3 = this.binding;
        if (activitySdkSettingBinding3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding3 = null;
        }
        activitySdkSettingBinding3.lytScanNfc.setOnClickListener(arg_0 -> SDKSettingScreen.initClick$lambda$3(this, arg_0));
        ActivitySdkSettingBinding activitySdkSettingBinding4 = this.binding;
        if (activitySdkSettingBinding4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding4 = null;
        }
        activitySdkSettingBinding4.lytScanLiveness.setOnClickListener(arg_0 -> SDKSettingScreen.initClick$lambda$4(this, arg_0));
        ActivitySdkSettingBinding activitySdkSettingBinding5 = this.binding;
        if (activitySdkSettingBinding5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding5 = null;
        }
        activitySdkSettingBinding5.lytScanNfcLiveness.setOnClickListener(arg_0 -> SDKSettingScreen.initClick$lambda$5(this, arg_0));
    }

    private final void handleClickofSelection(String selectedOption, ImageView imageview) {
        String string2 = this.lastSelectedFeature;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lastSelectedFeature");
            string2 = null;
        }
        Log.d((String)"TAG", (String)("handleClickofSelection: " + selectedOption + "   " + string2));
        String string3 = this.lastSelectedFeature;
        if (string3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lastSelectedFeature");
            string3 = null;
        }
        if (string3.equals(selectedOption)) {
            return;
        }
        this.deSelectAll();
        imageview.setImageResource(R.drawable.radio_on);
        this.callManageFeatureAPI(selectedOption);
    }

    private final void setLayoutAndTextSize() {
        ActivitySdkSettingBinding activitySdkSettingBinding;
        this.lastSelectedFeature = "";
        TextSizeConverter textSizeConverter = new TextSizeConverter(this.getApplicationContext());
        textSizeConverter.changeStatusBarColor((Activity)this);
        ActivitySdkSettingBinding activitySdkSettingBinding2 = this.binding;
        if (activitySdkSettingBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding2 = null;
        }
        ViewGroup.LayoutParams layoutParams2 = activitySdkSettingBinding2.lytHeaderMain.imgBack.getLayoutParams();
        layoutParams2.width = textSizeConverter.getWidth(24);
        layoutParams2.height = textSizeConverter.getHeight(24);
        ActivitySdkSettingBinding activitySdkSettingBinding3 = this.binding;
        if (activitySdkSettingBinding3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding3 = null;
        }
        activitySdkSettingBinding3.lytHeaderMain.imgBack.setLayoutParams(layoutParams2);
        if (StringsKt.equals((String)this.getStorage().getPreferredLocale(), (String)"ar", (boolean)true)) {
            ActivitySdkSettingBinding activitySdkSettingBinding4 = this.binding;
            if (activitySdkSettingBinding4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                activitySdkSettingBinding4 = null;
            }
            activitySdkSettingBinding4.lytHeaderMain.imgBack.setRotation(180.0f);
        }
        LinearLayout.LayoutParams layoutParams = textSizeConverter.getLinearLayoutParam();
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(4), 0, 0);
        ActivitySdkSettingBinding activitySdkSettingBinding5 = this.binding;
        if (activitySdkSettingBinding5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding5 = null;
        }
        activitySdkSettingBinding5.lytHeaderMain.lytHeaderMain.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        ActivitySdkSettingBinding activitySdkSettingBinding6 = this.binding;
        if (activitySdkSettingBinding6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding6 = null;
        }
        activitySdkSettingBinding6.lytHeaderMain.txtHelp.setText((CharSequence)this.getString(R.string.sdk_setting_header));
        ActivitySdkSettingBinding activitySdkSettingBinding7 = this.binding;
        if (activitySdkSettingBinding7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding7 = null;
        }
        activitySdkSettingBinding7.lytHeaderMain.txtHelp.setTextSize(0, textSizeConverter.getTextSize(17));
        ActivitySdkSettingBinding activitySdkSettingBinding8 = this.binding;
        if (activitySdkSettingBinding8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding8 = null;
        }
        activitySdkSettingBinding8.txtSelectVerification.setTextSize(0, textSizeConverter.getTextSize(32));
        int padding = textSizeConverter.getPaddingORMarginValue(16);
        ActivitySdkSettingBinding activitySdkSettingBinding9 = this.binding;
        if (activitySdkSettingBinding9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding9 = null;
        }
        activitySdkSettingBinding9.lytSettingMain.setPadding(padding, padding, padding, padding);
        padding = textSizeConverter.getPaddingORMarginValue(24);
        ActivitySdkSettingBinding activitySdkSettingBinding10 = this.binding;
        if (activitySdkSettingBinding10 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding10 = null;
        }
        activitySdkSettingBinding10.txtSelectVerification.setPadding(0, padding, 0, padding);
        layoutParams = textSizeConverter.getLinearLayoutParam();
        layoutParams.setMargins(0, 0, 0, 0);
        ActivitySdkSettingBinding activitySdkSettingBinding11 = this.binding;
        if (activitySdkSettingBinding11 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding11 = null;
        }
        activitySdkSettingBinding11.lytScan.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        layoutParams = textSizeConverter.getLinearLayoutParam();
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(16), 0, 0);
        ActivitySdkSettingBinding activitySdkSettingBinding12 = this.binding;
        if (activitySdkSettingBinding12 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding12 = null;
        }
        activitySdkSettingBinding12.lytScanNfc.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        layoutParams = textSizeConverter.getLinearLayoutParam();
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(16), 0, 0);
        ActivitySdkSettingBinding activitySdkSettingBinding13 = this.binding;
        if (activitySdkSettingBinding13 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding13 = null;
        }
        activitySdkSettingBinding13.lytScanLiveness.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        layoutParams = textSizeConverter.getLinearLayoutParam();
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(16), 0, 0);
        ActivitySdkSettingBinding activitySdkSettingBinding14 = this.binding;
        if (activitySdkSettingBinding14 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding14 = null;
        }
        activitySdkSettingBinding14.lytScanNfcLiveness.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        ActivitySdkSettingBinding activitySdkSettingBinding15 = this.binding;
        if (activitySdkSettingBinding15 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding15 = null;
        }
        activitySdkSettingBinding15.txtScan.setTextSize(0, textSizeConverter.getTextSize(18));
        ActivitySdkSettingBinding activitySdkSettingBinding16 = this.binding;
        if (activitySdkSettingBinding16 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding16 = null;
        }
        activitySdkSettingBinding16.txtScanNfc.setTextSize(0, textSizeConverter.getTextSize(18));
        ActivitySdkSettingBinding activitySdkSettingBinding17 = this.binding;
        if (activitySdkSettingBinding17 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding17 = null;
        }
        activitySdkSettingBinding17.txtScanLiveness.setTextSize(0, textSizeConverter.getTextSize(18));
        ActivitySdkSettingBinding activitySdkSettingBinding18 = this.binding;
        if (activitySdkSettingBinding18 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding18 = null;
        }
        activitySdkSettingBinding18.txtScanNfcLiveness.setTextSize(0, textSizeConverter.getTextSize(18));
        int imageSize = textSizeConverter.getWidth(20);
        ActivitySdkSettingBinding activitySdkSettingBinding19 = this.binding;
        if (activitySdkSettingBinding19 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding19 = null;
        }
        layoutParams2 = activitySdkSettingBinding19.imgScan.getLayoutParams();
        layoutParams2.width = imageSize;
        layoutParams2.height = imageSize;
        ActivitySdkSettingBinding activitySdkSettingBinding20 = this.binding;
        if (activitySdkSettingBinding20 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding20 = null;
        }
        activitySdkSettingBinding20.imgScan.setLayoutParams(layoutParams2);
        ActivitySdkSettingBinding activitySdkSettingBinding21 = this.binding;
        if (activitySdkSettingBinding21 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding21 = null;
        }
        layoutParams2 = activitySdkSettingBinding21.imgScanNfc.getLayoutParams();
        layoutParams2.width = imageSize;
        layoutParams2.height = imageSize;
        ActivitySdkSettingBinding activitySdkSettingBinding22 = this.binding;
        if (activitySdkSettingBinding22 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding22 = null;
        }
        activitySdkSettingBinding22.imgScanNfc.setLayoutParams(layoutParams2);
        ActivitySdkSettingBinding activitySdkSettingBinding23 = this.binding;
        if (activitySdkSettingBinding23 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding23 = null;
        }
        layoutParams2 = activitySdkSettingBinding23.imgScanLiveness.getLayoutParams();
        layoutParams2.width = imageSize;
        layoutParams2.height = imageSize;
        ActivitySdkSettingBinding activitySdkSettingBinding24 = this.binding;
        if (activitySdkSettingBinding24 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding24 = null;
        }
        activitySdkSettingBinding24.imgScanLiveness.setLayoutParams(layoutParams2);
        ActivitySdkSettingBinding activitySdkSettingBinding25 = this.binding;
        if (activitySdkSettingBinding25 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding25 = null;
        }
        layoutParams2 = activitySdkSettingBinding25.imgScanNfcLiveness.getLayoutParams();
        layoutParams2.width = imageSize;
        layoutParams2.height = imageSize;
        ActivitySdkSettingBinding activitySdkSettingBinding26 = this.binding;
        if (activitySdkSettingBinding26 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding26 = null;
        }
        activitySdkSettingBinding26.imgScanNfcLiveness.setLayoutParams(layoutParams2);
        padding = textSizeConverter.getPaddingORMarginValue(12);
        SVG back = null;
        try {
            back = SVG.getFromResource((Resources)this.getResources(), (int)R.raw.back);
            ActivitySdkSettingBinding activitySdkSettingBinding27 = this.binding;
            ActivitySdkSettingBinding activitySdkSettingBinding28 = activitySdkSettingBinding27;
            if (activitySdkSettingBinding28 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                activitySdkSettingBinding28 = null;
            }
            activitySdkSettingBinding28.lytHeaderMain.imgBack.setSVG(back);
        }
        catch (SVGParseException sVGParseException) {
            // empty catch block
        }
        if ((activitySdkSettingBinding = this.binding) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding = null;
        }
        layoutParams2 = activitySdkSettingBinding.imgLoader.getLayoutParams();
        layoutParams2.width = textSizeConverter.getWidth(24);
        layoutParams2.height = textSizeConverter.getHeight(24);
        ActivitySdkSettingBinding activitySdkSettingBinding29 = this.binding;
        if (activitySdkSettingBinding29 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding29 = null;
        }
        activitySdkSettingBinding29.imgLoader.setLayoutParams(layoutParams2);
        ActivitySdkSettingBinding activitySdkSettingBinding30 = this.binding;
        if (activitySdkSettingBinding30 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding30 = null;
        }
        ViewGroup.LayoutParams layoutParams3 = activitySdkSettingBinding30.txtValidating.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams3, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        LinearLayout.LayoutParams marginLyoutParam = (LinearLayout.LayoutParams)layoutParams3;
        marginLyoutParam.setMargins(0, textSizeConverter.getPaddingORMarginValue(32), 0, 0);
        ActivitySdkSettingBinding activitySdkSettingBinding31 = this.binding;
        if (activitySdkSettingBinding31 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding31 = null;
        }
        activitySdkSettingBinding31.txtValidating.setLayoutParams((ViewGroup.LayoutParams)marginLyoutParam);
        ActivitySdkSettingBinding activitySdkSettingBinding32 = this.binding;
        if (activitySdkSettingBinding32 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding32 = null;
        }
        activitySdkSettingBinding32.txtValidating.setTextSize(0, textSizeConverter.getTextSize(20));
        Animation rotation = AnimationUtils.loadAnimation((Context)((Context)this), (int)R.anim.rotate);
        rotation.setFillAfter(true);
        ActivitySdkSettingBinding activitySdkSettingBinding33 = this.binding;
        if (activitySdkSettingBinding33 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding33 = null;
        }
        activitySdkSettingBinding33.imgLoader.startAnimation(rotation);
    }

    private static final void onAvailable$lambda$0(SDKSettingScreen this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!this$0.isApiCalled) {
            this$0.callNashidFeatureCheckAPI();
        }
    }

    private static final void initClick$lambda$1(SDKSettingScreen this$0, View view) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.finish();
    }

    private static final void initClick$lambda$2(SDKSettingScreen this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ActivitySdkSettingBinding activitySdkSettingBinding = this$0.binding;
        if (activitySdkSettingBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding = null;
        }
        ImageView imageView = activitySdkSettingBinding.imgScan;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"imgScan");
        this$0.handleClickofSelection(SCAN, imageView);
    }

    private static final void initClick$lambda$3(SDKSettingScreen this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ActivitySdkSettingBinding activitySdkSettingBinding = this$0.binding;
        if (activitySdkSettingBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding = null;
        }
        ImageView imageView = activitySdkSettingBinding.imgScanNfc;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"imgScanNfc");
        this$0.handleClickofSelection("Scan,NFC", imageView);
    }

    private static final void initClick$lambda$4(SDKSettingScreen this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ActivitySdkSettingBinding activitySdkSettingBinding = this$0.binding;
        if (activitySdkSettingBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding = null;
        }
        ImageView imageView = activitySdkSettingBinding.imgScanLiveness;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"imgScanLiveness");
        this$0.handleClickofSelection("Scan,Liveness,Face-Match", imageView);
    }

    private static final void initClick$lambda$5(SDKSettingScreen this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ActivitySdkSettingBinding activitySdkSettingBinding = this$0.binding;
        if (activitySdkSettingBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activitySdkSettingBinding = null;
        }
        ImageView imageView = activitySdkSettingBinding.imgScanNfcLiveness;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"imgScanNfcLiveness");
        this$0.handleClickofSelection("Scan,NFC,Liveness,Face-Match", imageView);
    }

    public static final /* synthetic */ void access$setApiCalled$p(SDKSettingScreen $this, boolean bl) {
        $this.isApiCalled = bl;
    }

    public static final /* synthetic */ ActivitySdkSettingBinding access$getBinding$p(SDKSettingScreen $this) {
        return $this.binding;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lnashid/verify/sdk/mrtd2/activity/SDKSettingScreen$Companion;", "", "()V", "FACEMATCH", "", "LIVENESS", "NFC", "SCAN", "IDV_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

