/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.reader;

import colorspace.ChannelDefinitionMapper;
import colorspace.ColorSpace;
import colorspace.ColorSpaceException;
import colorspace.ColorSpaceMapper;
import colorspace.PalettizedColorSpaceMapper;
import colorspace.Resampler;
import icc.ICCProfileException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import jj2000.j2k.NotImplementedError;
import jj2000.j2k.codestream.CorruptedCodestreamException;
import jj2000.j2k.codestream.HeaderInfo;
import jj2000.j2k.codestream.Markers;
import jj2000.j2k.codestream.ProgressionType;
import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.entropy.StdEntropyCoderOptions;
import jj2000.j2k.entropy.decoder.CodedCBlkDataSrcDec;
import jj2000.j2k.entropy.decoder.EntropyDecoder;
import jj2000.j2k.entropy.decoder.StdEntropyDecoder;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.Coord;
import jj2000.j2k.io.RandomAccessIO;
import jj2000.j2k.quantization.dequantizer.CBlkQuantDataSrcDec;
import jj2000.j2k.quantization.dequantizer.Dequantizer;
import jj2000.j2k.quantization.dequantizer.StdDequantizer;
import jj2000.j2k.quantization.dequantizer.StdDequantizerParams;
import jj2000.j2k.roi.MaxShiftSpec;
import jj2000.j2k.roi.ROIDeScaler;
import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.wavelet.synthesis.SynWTFilter;
import jj2000.j2k.wavelet.synthesis.SynWTFilterFloatLift9x7;
import jj2000.j2k.wavelet.synthesis.SynWTFilterIntLift5x3;

public class HeaderDecoder
implements ProgressionType,
Markers,
StdEntropyCoderOptions {
    public static final char OPT_PREFIX = 'H';
    private static final String[][] pinfo = null;
    private HeaderInfo hi;
    private boolean verbose;
    private String hdStr = "";
    private int nTiles;
    public int[] nTileParts;
    private int nfMarkSeg = 0;
    private int nCOCMarkSeg = 0;
    private int nQCCMarkSeg = 0;
    private int nCOMMarkSeg = 0;
    private int nRGNMarkSeg = 0;
    private int nPPMMarkSeg = 0;
    private int[][] nPPTMarkSeg = null;
    private static final int SIZ_FOUND = 1;
    private static final int COD_FOUND = 2;
    private static final int COC_FOUND = 4;
    private static final int QCD_FOUND = 8;
    private static final int TLM_FOUND = 16;
    private static final int PLM_FOUND = 32;
    private static final int SOT_FOUND = 64;
    private static final int PLT_FOUND = 128;
    private static final int QCC_FOUND = 256;
    private static final int RGN_FOUND = 512;
    private static final int POC_FOUND = 1024;
    private static final int COM_FOUND = 2048;
    public static final int SOD_FOUND = 8192;
    public static final int PPM_FOUND = 16384;
    public static final int PPT_FOUND = 32768;
    public static final int CRG_FOUND = 65536;
    private static final int TILE_RESET = -546;
    private Hashtable ht = null;
    private int nComp;
    private int cb0x = -1;
    private int cb0y = -1;
    private DecoderSpecs decSpec;
    boolean precinctPartitionIsUsed;
    public int mainHeadOff;
    public Vector tileOfTileParts;
    private byte[][] pPMMarkerData;
    private byte[][][][] tilePartPkdPktHeaders;
    private ByteArrayOutputStream[] pkdPktHeaders;

    public int getMaxCompImgHeight() {
        return this.hi.siz.getMaxCompHeight();
    }

    public int getMaxCompImgWidth() {
        return this.hi.siz.getMaxCompWidth();
    }

    public final int getImgWidth() {
        return this.hi.siz.xsiz - this.hi.siz.x0siz;
    }

    public final int getImgHeight() {
        return this.hi.siz.ysiz - this.hi.siz.y0siz;
    }

    public final int getImgULX() {
        return this.hi.siz.x0siz;
    }

    public final int getImgULY() {
        return this.hi.siz.y0siz;
    }

    public final int getNomTileWidth() {
        return this.hi.siz.xtsiz;
    }

    public final int getNomTileHeight() {
        return this.hi.siz.ytsiz;
    }

    public final Coord getTilingOrigin(Coord coord) {
        if (coord != null) {
            coord.x = this.hi.siz.xt0siz;
            coord.y = this.hi.siz.yt0siz;
            return coord;
        }
        return new Coord(this.hi.siz.xt0siz, this.hi.siz.yt0siz);
    }

    public final boolean isOriginalSigned(int n) {
        return this.hi.siz.isOrigSigned(n);
    }

    public final int getOriginalBitDepth(int n) {
        return this.hi.siz.getOrigBitDepth(n);
    }

    public final int getNumComps() {
        return this.nComp;
    }

    public final int getCompSubsX(int n) {
        return this.hi.siz.xrsiz[n];
    }

    public final int getCompSubsY(int n) {
        return this.hi.siz.yrsiz[n];
    }

    public final Dequantizer createDequantizer(CBlkQuantDataSrcDec cBlkQuantDataSrcDec, int[] nArray, DecoderSpecs decoderSpecs) {
        return new StdDequantizer(cBlkQuantDataSrcDec, nArray, decoderSpecs);
    }

    public final int getCbULX() {
        return this.cb0x;
    }

    public final int getCbULY() {
        return this.cb0y;
    }

    public final int getPPX(int n, int n2, int n3) {
        return this.decSpec.pss.getPPX(n, n2, n3);
    }

    public final int getPPY(int n, int n2, int n3) {
        return this.decSpec.pss.getPPY(n, n2, n3);
    }

    public final boolean precinctPartitionUsed() {
        return this.precinctPartitionIsUsed;
    }

    private SynWTFilter readFilter(DataInputStream dataInputStream, int[] nArray) throws IOException {
        nArray[0] = dataInputStream.readUnsignedByte();
        int n = nArray[0];
        if (n >= 128) {
            throw new NotImplementedError("Custom filters not supported");
        }
        switch (n) {
            case 0: {
                return new SynWTFilterFloatLift9x7();
            }
            case 1: {
                return new SynWTFilterIntLift5x3();
            }
        }
        throw new CorruptedCodestreamException("Specified wavelet filter not JPEG 2000 part I compliant");
    }

    public void checkMarkerLength(DataInputStream dataInputStream, String string) throws IOException {
        if (dataInputStream.available() != 0) {
            FacilityManager.getMsgLogger().printmsg(2, string + " length was short, attempting to resync.");
        }
    }

    private void readSIZ(DataInputStream dataInputStream) throws IOException {
        HeaderInfo.SIZ sIZ;
        this.hi.siz = sIZ = this.hi.getNewSIZ();
        sIZ.lsiz = dataInputStream.readUnsignedShort();
        sIZ.rsiz = dataInputStream.readUnsignedShort();
        if (sIZ.rsiz > 2) {
            throw new Error("Codestream capabiities not JPEG 2000 - Part I compliant");
        }
        sIZ.xsiz = dataInputStream.readInt();
        sIZ.ysiz = dataInputStream.readInt();
        if (sIZ.xsiz <= 0 || sIZ.ysiz <= 0) {
            throw new IOException("JJ2000 does not support images whose width and/or height not in the range: 1 -- (2^31)-1");
        }
        sIZ.x0siz = dataInputStream.readInt();
        sIZ.y0siz = dataInputStream.readInt();
        if (sIZ.x0siz < 0 || sIZ.y0siz < 0) {
            throw new IOException("JJ2000 does not support images offset not in the range: 0 -- (2^31)-1");
        }
        sIZ.xtsiz = dataInputStream.readInt();
        sIZ.ytsiz = dataInputStream.readInt();
        if (sIZ.xtsiz <= 0 || sIZ.ytsiz <= 0) {
            throw new IOException("JJ2000 does not support tiles whose width and/or height are not in  the range: 1 -- (2^31)-1");
        }
        sIZ.xt0siz = dataInputStream.readInt();
        sIZ.yt0siz = dataInputStream.readInt();
        if (sIZ.xt0siz < 0 || sIZ.yt0siz < 0) {
            throw new IOException("JJ2000 does not support tiles whose offset is not in  the range: 0 -- (2^31)-1");
        }
        this.nComp = sIZ.csiz = dataInputStream.readUnsignedShort();
        if (this.nComp < 1 || this.nComp > 16384) {
            throw new IllegalArgumentException("Number of component out of range 1--16384: " + this.nComp);
        }
        sIZ.ssiz = new int[this.nComp];
        sIZ.xrsiz = new int[this.nComp];
        sIZ.yrsiz = new int[this.nComp];
        for (int i = 0; i < this.nComp; ++i) {
            sIZ.ssiz[i] = dataInputStream.readUnsignedByte();
            sIZ.xrsiz[i] = dataInputStream.readUnsignedByte();
            sIZ.yrsiz[i] = dataInputStream.readUnsignedByte();
        }
        this.checkMarkerLength(dataInputStream, "SIZ marker");
        this.nTiles = sIZ.getNumTiles();
        this.decSpec = new DecoderSpecs(this.nTiles, this.nComp);
    }

    private void readCRG(DataInputStream dataInputStream) throws IOException {
        HeaderInfo.CRG cRG;
        this.hi.crg = cRG = this.hi.getNewCRG();
        cRG.lcrg = dataInputStream.readUnsignedShort();
        cRG.xcrg = new int[this.nComp];
        cRG.ycrg = new int[this.nComp];
        FacilityManager.getMsgLogger().printmsg(2, "Information in CRG marker segment not taken into account. This may affect the display of the decoded image.");
        for (int i = 0; i < this.nComp; ++i) {
            cRG.xcrg[i] = dataInputStream.readUnsignedShort();
            cRG.ycrg[i] = dataInputStream.readUnsignedShort();
        }
        this.checkMarkerLength(dataInputStream, "CRG marker");
    }

    private void readCOM(DataInputStream dataInputStream, boolean bl, int n, int n2) throws IOException {
        HeaderInfo.COM cOM = this.hi.getNewCOM();
        cOM.lcom = dataInputStream.readUnsignedShort();
        cOM.rcom = dataInputStream.readUnsignedShort();
        switch (cOM.rcom) {
            case 1: {
                cOM.ccom = new byte[cOM.lcom - 4];
                for (int i = 0; i < cOM.lcom - 4; ++i) {
                    cOM.ccom[i] = dataInputStream.readByte();
                }
                break;
            }
            default: {
                FacilityManager.getMsgLogger().printmsg(2, "COM marker registered as 0x" + Integer.toHexString(cOM.rcom) + " unknown, ignoring (this might crash the " + "decoder or decode a quality degraded or even " + "useless image)");
                dataInputStream.skipBytes(cOM.lcom - 4);
            }
        }
        if (bl) {
            this.hi.com.put("main_" + n2, cOM);
        } else {
            this.hi.com.put("t" + n + "_" + n2, cOM);
        }
        this.checkMarkerLength(dataInputStream, "COM marker");
    }

    private void readQCD(DataInputStream dataInputStream, boolean bl, int n, int n2) throws IOException {
        int n3;
        int n4;
        Object object;
        block23: {
            HeaderInfo.QCD qCD;
            block22: {
                object = null;
                qCD = this.hi.getNewQCD();
                qCD.lqcd = dataInputStream.readUnsignedShort();
                qCD.sqcd = dataInputStream.readUnsignedByte();
                n4 = qCD.getNumGuardBits();
                n3 = qCD.getQuantType();
                if (!bl) break block22;
                this.hi.qcd.put("main", qCD);
                switch (n3) {
                    case 0: {
                        this.decSpec.qts.setDefault("reversible");
                        break block23;
                    }
                    case 1: {
                        this.decSpec.qts.setDefault("derived");
                        break block23;
                    }
                    case 2: {
                        this.decSpec.qts.setDefault("expounded");
                        break block23;
                    }
                    default: {
                        throw new CorruptedCodestreamException("Unknown or unsupported quantization style in Sqcd field, QCD marker main header");
                    }
                }
            }
            this.hi.qcd.put("t" + n, qCD);
            switch (n3) {
                case 0: {
                    this.decSpec.qts.setTileDef(n, "reversible");
                    break;
                }
                case 1: {
                    this.decSpec.qts.setTileDef(n, "derived");
                    break;
                }
                case 2: {
                    this.decSpec.qts.setTileDef(n, "expounded");
                    break;
                }
                default: {
                    throw new CorruptedCodestreamException("Unknown or unsupported quantization style in Sqcd field, QCD marker, tile header");
                }
            }
        }
        StdDequantizerParams stdDequantizerParams = new StdDequantizerParams();
        if (n3 == 0) {
            int n5 = bl ? ((Integer)this.decSpec.dls.getDefault()).intValue() : ((Integer)this.decSpec.dls.getTileDef(n)).intValue();
            int[][] nArrayArray = new int[n5 + 1][];
            stdDequantizerParams.exp = nArrayArray;
            int[][] nArrayArray2 = nArrayArray;
            qCD.spqcd = new int[n5 + 1][4];
            for (int i = 0; i <= n5; ++i) {
                int n6;
                int n7;
                if (i == 0) {
                    n7 = 0;
                    n6 = 1;
                } else {
                    int n8 = 1;
                    n8 = n8 > n5 - i ? (n8 -= n5 - i) : 1;
                    n7 = 1 << (n8 - 1 << 1);
                    n6 = 1 << (n8 << 1);
                }
                nArrayArray2[i] = new int[n6];
                for (int j = n7; j < n6; ++j) {
                    int n9 = dataInputStream.readUnsignedByte();
                    qCD.spqcd[i][j] = n9;
                    int n10 = n9;
                    nArrayArray2[i][j] = n10 >> 3 & 0x1F;
                }
            }
        } else {
            int n11 = n3 == 1 ? 0 : (bl ? ((Integer)this.decSpec.dls.getDefault()).intValue() : ((Integer)this.decSpec.dls.getTileDef(n)).intValue());
            int[][] nArrayArray = new int[n11 + 1][];
            stdDequantizerParams.exp = nArrayArray;
            int[][] nArrayArray3 = nArrayArray;
            float[][] fArrayArray = new float[n11 + 1][];
            stdDequantizerParams.nStep = fArrayArray;
            object = fArrayArray;
            qCD.spqcd = new int[n11 + 1][4];
            for (int i = 0; i <= n11; ++i) {
                int n12;
                int n13;
                if (i == 0) {
                    n13 = 0;
                    n12 = 1;
                } else {
                    int n14 = 1;
                    n14 = n14 > n11 - i ? (n14 -= n11 - i) : 1;
                    n13 = 1 << (n14 - 1 << 1);
                    n12 = 1 << (n14 << 1);
                }
                nArrayArray3[i] = new int[n12];
                object[i] = new float[n12];
                for (int j = n13; j < n12; ++j) {
                    int n15 = dataInputStream.readUnsignedShort();
                    qCD.spqcd[i][j] = n15;
                    int n16 = n15;
                    nArrayArray3[i][j] = n16 >> 11 & 0x1F;
                    object[i][j] = (-1.0f - (float)(n16 & 0x7FF) / 2048.0f) / (float)(-1 << nArrayArray3[i][j]);
                }
            }
        }
        if (bl) {
            this.decSpec.qsss.setDefault(stdDequantizerParams);
            this.decSpec.gbs.setDefault(new Integer(n4));
        } else {
            this.decSpec.qsss.setTileDef(n, stdDequantizerParams);
            this.decSpec.gbs.setTileDef(n, new Integer(n4));
        }
        this.checkMarkerLength(dataInputStream, "QCD marker");
    }

    private void readQCC(DataInputStream dataInputStream, boolean bl, int n, int n2) throws IOException {
        int n3;
        int n4;
        int n5;
        Object object;
        block24: {
            HeaderInfo.QCC qCC;
            block23: {
                object = null;
                qCC = this.hi.getNewQCC();
                qCC.lqcc = dataInputStream.readUnsignedShort();
                n5 = this.nComp < 257 ? (qCC.cqcc = dataInputStream.readUnsignedByte()) : (qCC.cqcc = dataInputStream.readUnsignedShort());
                if (n5 >= this.nComp) {
                    throw new CorruptedCodestreamException("Invalid component index in QCC marker");
                }
                qCC.sqcc = dataInputStream.readUnsignedByte();
                n4 = qCC.getNumGuardBits();
                n3 = qCC.getQuantType();
                if (!bl) break block23;
                this.hi.qcc.put("main_c" + n5, qCC);
                switch (n3) {
                    case 0: {
                        this.decSpec.qts.setCompDef(n5, "reversible");
                        break block24;
                    }
                    case 1: {
                        this.decSpec.qts.setCompDef(n5, "derived");
                        break block24;
                    }
                    case 2: {
                        this.decSpec.qts.setCompDef(n5, "expounded");
                        break block24;
                    }
                    default: {
                        throw new CorruptedCodestreamException("Unknown or unsupported quantization style in Sqcd field, QCD marker, main header");
                    }
                }
            }
            this.hi.qcc.put("t" + n + "_c" + n5, qCC);
            switch (n3) {
                case 0: {
                    this.decSpec.qts.setTileCompVal(n, n5, "reversible");
                    break;
                }
                case 1: {
                    this.decSpec.qts.setTileCompVal(n, n5, "derived");
                    break;
                }
                case 2: {
                    this.decSpec.qts.setTileCompVal(n, n5, "expounded");
                    break;
                }
                default: {
                    throw new CorruptedCodestreamException("Unknown or unsupported quantization style in Sqcd field, QCD marker, main header");
                }
            }
        }
        StdDequantizerParams stdDequantizerParams = new StdDequantizerParams();
        if (n3 == 0) {
            int n6 = bl ? ((Integer)this.decSpec.dls.getCompDef(n5)).intValue() : ((Integer)this.decSpec.dls.getTileCompVal(n, n5)).intValue();
            int[][] nArrayArray = new int[n6 + 1][];
            stdDequantizerParams.exp = nArrayArray;
            int[][] nArrayArray2 = nArrayArray;
            qCC.spqcc = new int[n6 + 1][4];
            for (int i = 0; i <= n6; ++i) {
                int n7;
                int n8;
                if (i == 0) {
                    n8 = 0;
                    n7 = 1;
                } else {
                    int n9 = 1;
                    n9 = n9 > n6 - i ? (n9 -= n6 - i) : 1;
                    n8 = 1 << (n9 - 1 << 1);
                    n7 = 1 << (n9 << 1);
                }
                nArrayArray2[i] = new int[n7];
                for (int j = n8; j < n7; ++j) {
                    int n10 = dataInputStream.readUnsignedByte();
                    qCC.spqcc[i][j] = n10;
                    int n11 = n10;
                    nArrayArray2[i][j] = n11 >> 3 & 0x1F;
                }
            }
        } else {
            int n12 = n3 == 1 ? 0 : (bl ? ((Integer)this.decSpec.dls.getCompDef(n5)).intValue() : ((Integer)this.decSpec.dls.getTileCompVal(n, n5)).intValue());
            float[][] fArrayArray = new float[n12 + 1][];
            stdDequantizerParams.nStep = fArrayArray;
            object = fArrayArray;
            int[][] nArrayArray = new int[n12 + 1][];
            stdDequantizerParams.exp = nArrayArray;
            int[][] nArrayArray3 = nArrayArray;
            qCC.spqcc = new int[n12 + 1][4];
            for (int i = 0; i <= n12; ++i) {
                int n13;
                int n14;
                if (i == 0) {
                    n14 = 0;
                    n13 = 1;
                } else {
                    int n15 = 1;
                    n15 = n15 > n12 - i ? (n15 -= n12 - i) : 1;
                    n14 = 1 << (n15 - 1 << 1);
                    n13 = 1 << (n15 << 1);
                }
                nArrayArray3[i] = new int[n13];
                object[i] = new float[n13];
                for (int j = n14; j < n13; ++j) {
                    int n16 = dataInputStream.readUnsignedShort();
                    qCC.spqcc[i][j] = n16;
                    int n17 = n16;
                    nArrayArray3[i][j] = n17 >> 11 & 0x1F;
                    object[i][j] = (-1.0f - (float)(n17 & 0x7FF) / 2048.0f) / (float)(-1 << nArrayArray3[i][j]);
                }
            }
        }
        if (bl) {
            this.decSpec.qsss.setCompDef(n5, stdDequantizerParams);
            this.decSpec.gbs.setCompDef(n5, new Integer(n4));
        } else {
            this.decSpec.qsss.setTileCompVal(n, n5, stdDequantizerParams);
            this.decSpec.gbs.setTileCompVal(n, n5, new Integer(n4));
        }
        this.checkMarkerLength(dataInputStream, "QCC marker");
    }

    private void readCOD(DataInputStream dataInputStream, boolean bl, int n, int n2) throws IOException {
        boolean bl2 = false;
        boolean bl3 = false;
        HeaderInfo.COD cOD = this.hi.getNewCOD();
        cOD.lcod = dataInputStream.readUnsignedShort();
        cOD.scod = dataInputStream.readUnsignedByte();
        int n3 = cOD.scod;
        if ((n3 & 1) != 0) {
            this.precinctPartitionIsUsed = true;
            n3 &= 0xFFFFFFFE;
        } else {
            this.precinctPartitionIsUsed = false;
        }
        if (bl) {
            this.hi.cod.put("main", cOD);
            if ((n3 & 2) != 0) {
                this.decSpec.sops.setDefault(new Boolean("true"));
                bl2 = true;
                n3 &= 0xFFFFFFFD;
            } else {
                this.decSpec.sops.setDefault(new Boolean("false"));
            }
        } else {
            this.hi.cod.put("t" + n, cOD);
            if ((n3 & 2) != 0) {
                this.decSpec.sops.setTileDef(n, new Boolean("true"));
                bl2 = true;
                n3 &= 0xFFFFFFFD;
            } else {
                this.decSpec.sops.setTileDef(n, new Boolean("false"));
            }
        }
        if (bl) {
            if ((n3 & 4) != 0) {
                this.decSpec.ephs.setDefault(new Boolean("true"));
                bl3 = true;
                n3 &= 0xFFFFFFFB;
            } else {
                this.decSpec.ephs.setDefault(new Boolean("false"));
            }
        } else if ((n3 & 4) != 0) {
            this.decSpec.ephs.setTileDef(n, new Boolean("true"));
            bl3 = true;
            n3 &= 0xFFFFFFFB;
        } else {
            this.decSpec.ephs.setTileDef(n, new Boolean("false"));
        }
        if ((n3 & 0x18) != 0) {
            FacilityManager.getMsgLogger().printmsg(2, "Code-block partition origin different from (0,0). This is defined in JPEG 2000 part 2 and may not be supported by all JPEG 2000 decoders.");
        }
        if ((n3 & 8) != 0) {
            if (this.cb0x != -1 && this.cb0x == 0) {
                throw new IllegalArgumentException("Code-block partition origin redefined in new COD marker segment. Not supported by JJ2000");
            }
            this.cb0x = 1;
            n3 &= 0xFFFFFFF7;
        } else {
            if (this.cb0x != -1 && this.cb0x == 1) {
                throw new IllegalArgumentException("Code-block partition origin redefined in new COD marker segment. Not supported by JJ2000");
            }
            this.cb0x = 0;
        }
        if ((n3 & 0x10) != 0) {
            if (this.cb0y != -1 && this.cb0y == 0) {
                throw new IllegalArgumentException("Code-block partition origin redefined in new COD marker segment. Not supported by JJ2000");
            }
            this.cb0y = 1;
            n3 &= 0xFFFFFFEF;
        } else {
            if (this.cb0y != -1 && this.cb0y == 1) {
                throw new IllegalArgumentException("Code-block partition origin redefined in new COD marker segment. Not supported by JJ2000");
            }
            this.cb0y = 0;
        }
        cOD.sgcod_po = dataInputStream.readUnsignedByte();
        cOD.sgcod_nl = dataInputStream.readUnsignedShort();
        if (cOD.sgcod_nl <= 0 || cOD.sgcod_nl > 65535) {
            throw new CorruptedCodestreamException("Number of layers out of range: 1--65535");
        }
        cOD.sgcod_mct = dataInputStream.readUnsignedByte();
        cOD.spcod_ndl = dataInputStream.readUnsignedByte();
        int n4 = cOD.spcod_ndl;
        if (n4 > 32) {
            throw new CorruptedCodestreamException("Number of decomposition levels out of range: 0--32");
        }
        Integer[] integerArray = new Integer[2];
        cOD.spcod_cw = dataInputStream.readUnsignedByte();
        integerArray[0] = new Integer(1 << cOD.spcod_cw + 2);
        if (integerArray[0] < 4 || integerArray[0] > 1024) {
            String string = "Non-valid code-block width in SPcod field, COD marker";
            throw new CorruptedCodestreamException(string);
        }
        cOD.spcod_ch = dataInputStream.readUnsignedByte();
        integerArray[1] = new Integer(1 << cOD.spcod_ch + 2);
        if (integerArray[1] < 4 || integerArray[1] > 1024) {
            String string = "Non-valid code-block height in SPcod field, COD marker";
            throw new CorruptedCodestreamException(string);
        }
        if (integerArray[0] * integerArray[1] > 4096) {
            String string = "Non-valid code-block area in SPcod field, COD marker";
            throw new CorruptedCodestreamException(string);
        }
        if (bl) {
            this.decSpec.cblks.setDefault(integerArray);
        } else {
            this.decSpec.cblks.setTileDef(n, integerArray);
        }
        int n5 = cOD.spcod_cs = dataInputStream.readUnsignedByte();
        if ((n5 & 0xFFFFFFC0) != 0) {
            throw new CorruptedCodestreamException("Unknown \"code-block style\" in SPcod field, COD marker: 0x" + Integer.toHexString(n5));
        }
        SynWTFilter[] synWTFilterArray = new SynWTFilter[1];
        SynWTFilter[] synWTFilterArray2 = new SynWTFilter[1];
        synWTFilterArray[0] = this.readFilter(dataInputStream, cOD.spcod_t);
        synWTFilterArray2[0] = synWTFilterArray[0];
        SynWTFilter[][] synWTFilterArrayArray = new SynWTFilter[][]{synWTFilterArray, synWTFilterArray2};
        Vector[] vectorArray = new Vector[]{new Vector(), new Vector()};
        int n6 = 65535;
        if (!this.precinctPartitionIsUsed) {
            Integer n7 = new Integer(1 << (n6 & 0xF));
            vectorArray[0].addElement(n7);
            Integer n8 = new Integer(1 << ((n6 & 0xF0) >> 4));
            vectorArray[1].addElement(n8);
        } else {
            cOD.spcod_ps = new int[n4 + 1];
            for (int i = n4; i >= 0; --i) {
                int n9 = dataInputStream.readUnsignedByte();
                cOD.spcod_ps[n4 - i] = n9;
                n6 = n9;
                Integer n10 = new Integer(1 << (n6 & 0xF));
                vectorArray[0].insertElementAt(n10, 0);
                Integer n11 = new Integer(1 << ((n6 & 0xF0) >> 4));
                vectorArray[1].insertElementAt(n11, 0);
            }
        }
        if (bl) {
            this.decSpec.pss.setDefault(vectorArray);
        } else {
            this.decSpec.pss.setTileDef(n, vectorArray);
        }
        this.precinctPartitionIsUsed = true;
        this.checkMarkerLength(dataInputStream, "COD marker");
        if (bl) {
            this.decSpec.wfs.setDefault(synWTFilterArrayArray);
            this.decSpec.dls.setDefault(new Integer(n4));
            this.decSpec.ecopts.setDefault(new Integer(n5));
            this.decSpec.cts.setDefault(new Integer(cOD.sgcod_mct));
            this.decSpec.nls.setDefault(new Integer(cOD.sgcod_nl));
            this.decSpec.pos.setDefault(new Integer(cOD.sgcod_po));
        } else {
            this.decSpec.wfs.setTileDef(n, synWTFilterArrayArray);
            this.decSpec.dls.setTileDef(n, new Integer(n4));
            this.decSpec.ecopts.setTileDef(n, new Integer(n5));
            this.decSpec.cts.setTileDef(n, new Integer(cOD.sgcod_mct));
            this.decSpec.nls.setTileDef(n, new Integer(cOD.sgcod_nl));
            this.decSpec.pos.setTileDef(n, new Integer(cOD.sgcod_po));
        }
    }

    private void readCOC(DataInputStream dataInputStream, boolean bl, int n, int n2) throws IOException {
        HeaderInfo.COC cOC = this.hi.getNewCOC();
        cOC.lcoc = dataInputStream.readUnsignedShort();
        int n3 = this.nComp < 257 ? (cOC.ccoc = dataInputStream.readUnsignedByte()) : (cOC.ccoc = dataInputStream.readUnsignedShort());
        if (n3 >= this.nComp) {
            throw new CorruptedCodestreamException("Invalid component index in QCC marker");
        }
        cOC.scoc = dataInputStream.readUnsignedByte();
        int n4 = cOC.scoc;
        if ((n4 & 1) != 0) {
            this.precinctPartitionIsUsed = true;
            n4 &= 0xFFFFFFFE;
        } else {
            this.precinctPartitionIsUsed = false;
        }
        int n5 = cOC.spcoc_ndl = dataInputStream.readUnsignedByte();
        Integer[] integerArray = new Integer[2];
        cOC.spcoc_cw = dataInputStream.readUnsignedByte();
        integerArray[0] = new Integer(1 << cOC.spcoc_cw + 2);
        if (integerArray[0] < 4 || integerArray[0] > 1024) {
            String string = "Non-valid code-block width in SPcod field, COC marker";
            throw new CorruptedCodestreamException(string);
        }
        cOC.spcoc_ch = dataInputStream.readUnsignedByte();
        integerArray[1] = new Integer(1 << cOC.spcoc_ch + 2);
        if (integerArray[1] < 4 || integerArray[1] > 1024) {
            String string = "Non-valid code-block height in SPcod field, COC marker";
            throw new CorruptedCodestreamException(string);
        }
        if (integerArray[0] * integerArray[1] > 4096) {
            String string = "Non-valid code-block area in SPcod field, COC marker";
            throw new CorruptedCodestreamException(string);
        }
        if (bl) {
            this.decSpec.cblks.setCompDef(n3, integerArray);
        } else {
            this.decSpec.cblks.setTileCompVal(n, n3, integerArray);
        }
        int n6 = cOC.spcoc_cs = dataInputStream.readUnsignedByte();
        if ((n6 & 0xFFFFFFC0) != 0) {
            throw new CorruptedCodestreamException("Unknown \"code-block context\" in SPcoc field, COC marker: 0x" + Integer.toHexString(n6));
        }
        SynWTFilter[] synWTFilterArray = new SynWTFilter[1];
        SynWTFilter[] synWTFilterArray2 = new SynWTFilter[1];
        synWTFilterArray[0] = this.readFilter(dataInputStream, cOC.spcoc_t);
        synWTFilterArray2[0] = synWTFilterArray[0];
        SynWTFilter[][] synWTFilterArrayArray = new SynWTFilter[][]{synWTFilterArray, synWTFilterArray2};
        Vector[] vectorArray = new Vector[]{new Vector(), new Vector()};
        int n7 = 65535;
        if (!this.precinctPartitionIsUsed) {
            Integer n8 = new Integer(1 << (n7 & 0xF));
            vectorArray[0].addElement(n8);
            Integer n9 = new Integer(1 << ((n7 & 0xF0) >> 4));
            vectorArray[1].addElement(n9);
        } else {
            cOC.spcoc_ps = new int[n5 + 1];
            for (int i = n5; i >= 0; --i) {
                n7 = cOC.spcoc_ps[i] = dataInputStream.readUnsignedByte();
                Integer n10 = new Integer(1 << (n7 & 0xF));
                vectorArray[0].insertElementAt(n10, 0);
                Integer n11 = new Integer(1 << ((n7 & 0xF0) >> 4));
                vectorArray[1].insertElementAt(n11, 0);
            }
        }
        if (bl) {
            this.decSpec.pss.setCompDef(n3, vectorArray);
        } else {
            this.decSpec.pss.setTileCompVal(n, n3, vectorArray);
        }
        this.precinctPartitionIsUsed = true;
        this.checkMarkerLength(dataInputStream, "COD marker");
        if (bl) {
            this.hi.coc.put("main_c" + n3, cOC);
            this.decSpec.wfs.setCompDef(n3, synWTFilterArrayArray);
            this.decSpec.dls.setCompDef(n3, new Integer(n5));
            this.decSpec.ecopts.setCompDef(n3, new Integer(n6));
        } else {
            this.hi.coc.put("t" + n + "_c" + n3, cOC);
            this.decSpec.wfs.setTileCompVal(n, n3, synWTFilterArrayArray);
            this.decSpec.dls.setTileCompVal(n, n3, new Integer(n5));
            this.decSpec.ecopts.setTileCompVal(n, n3, new Integer(n6));
        }
    }

    private void readPOC(DataInputStream dataInputStream, boolean bl, int n, int n2) throws IOException {
        int[][] nArray;
        HeaderInfo.POC pOC;
        boolean bl2 = this.nComp >= 256;
        int n3 = 0;
        if (bl || this.hi.poc.get("t" + n) == null) {
            pOC = this.hi.getNewPOC();
        } else {
            pOC = (HeaderInfo.POC)this.hi.poc.get("t" + n);
            n3 = pOC.rspoc.length;
        }
        pOC.lpoc = dataInputStream.readUnsignedShort();
        int n4 = (pOC.lpoc - 2) / (5 + (bl2 ? 4 : 2));
        int n5 = n3 + n4;
        if (n3 != 0) {
            nArray = new int[n5][6];
            int[] nArray2 = new int[n5];
            int[] nArray3 = new int[n5];
            int[] nArray4 = new int[n5];
            int[] nArray5 = new int[n5];
            int[] nArray6 = new int[n5];
            int[] nArray7 = new int[n5];
            int[][] nArray8 = (int[][])this.decSpec.pcs.getTileDef(n);
            for (int i = 0; i < n3; ++i) {
                nArray[i] = nArray8[i];
                nArray2[i] = pOC.rspoc[i];
                nArray3[i] = pOC.cspoc[i];
                nArray4[i] = pOC.lyepoc[i];
                nArray5[i] = pOC.repoc[i];
                nArray6[i] = pOC.cepoc[i];
                nArray7[i] = pOC.ppoc[i];
            }
            pOC.rspoc = nArray2;
            pOC.cspoc = nArray3;
            pOC.lyepoc = nArray4;
            pOC.repoc = nArray5;
            pOC.cepoc = nArray6;
            pOC.ppoc = nArray7;
        } else {
            nArray = new int[n4][6];
            pOC.rspoc = new int[n4];
            pOC.cspoc = new int[n4];
            pOC.lyepoc = new int[n4];
            pOC.repoc = new int[n4];
            pOC.cepoc = new int[n4];
            pOC.ppoc = new int[n4];
        }
        for (int i = n3; i < n5; ++i) {
            int n6;
            nArray[i][0] = pOC.rspoc[i] = dataInputStream.readUnsignedByte();
            nArray[i][1] = bl2 ? (pOC.cspoc[i] = dataInputStream.readUnsignedShort()) : (pOC.cspoc[i] = dataInputStream.readUnsignedByte());
            nArray[i][2] = pOC.lyepoc[i] = dataInputStream.readUnsignedShort();
            if (nArray[i][2] < 1) {
                throw new CorruptedCodestreamException("LYEpoc value must be greater than 1 in POC marker segment of tile " + n + ", tile-part " + n2);
            }
            nArray[i][3] = pOC.repoc[i] = dataInputStream.readUnsignedByte();
            if (nArray[i][3] <= nArray[i][0]) {
                throw new CorruptedCodestreamException("REpoc value must be greater than RSpoc in POC marker segment of tile " + n + ", tile-part " + n2);
            }
            nArray[i][4] = bl2 ? (pOC.cepoc[i] = dataInputStream.readUnsignedShort()) : ((n6 = (pOC.cepoc[i] = dataInputStream.readUnsignedByte())) == 0 ? 0 : n6);
            if (nArray[i][4] <= nArray[i][1]) {
                throw new CorruptedCodestreamException("CEpoc value must be greater than CSpoc in POC marker segment of tile " + n + ", tile-part " + n2);
            }
            nArray[i][5] = pOC.ppoc[i] = dataInputStream.readUnsignedByte();
        }
        this.checkMarkerLength(dataInputStream, "POC marker");
        if (bl) {
            this.hi.poc.put("main", pOC);
            this.decSpec.pcs.setDefault(nArray);
        } else {
            this.hi.poc.put("t" + n, pOC);
            this.decSpec.pcs.setTileDef(n, nArray);
        }
    }

    private void readTLM(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        dataInputStream.skipBytes(n - 2);
        FacilityManager.getMsgLogger().printmsg(1, "Skipping unsupported TLM marker");
    }

    private void readPLM(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        dataInputStream.skipBytes(n - 2);
        FacilityManager.getMsgLogger().printmsg(1, "Skipping unsupported PLM marker");
    }

    private void readPLTFields(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        dataInputStream.skipBytes(n - 2);
        FacilityManager.getMsgLogger().printmsg(1, "Skipping unsupported PLT marker");
    }

    private void readRGN(DataInputStream dataInputStream, boolean bl, int n, int n2) throws IOException {
        HeaderInfo.RGN rGN = this.hi.getNewRGN();
        rGN.lrgn = dataInputStream.readUnsignedShort();
        int n3 = this.nComp < 257 ? dataInputStream.readUnsignedByte() : dataInputStream.readUnsignedShort();
        rGN.crgn = n3;
        if (n3 >= this.nComp) {
            throw new CorruptedCodestreamException("Invalid component index in RGN marker" + n3);
        }
        rGN.srgn = dataInputStream.readUnsignedByte();
        if (rGN.srgn != 0) {
            throw new CorruptedCodestreamException("Unknown or unsupported Srgn parameter in ROI marker");
        }
        if (this.decSpec.rois == null) {
            this.decSpec.rois = new MaxShiftSpec(this.nTiles, this.nComp, 2);
        }
        rGN.sprgn = dataInputStream.readUnsignedByte();
        if (bl) {
            this.hi.rgn.put("main_c" + n3, rGN);
            this.decSpec.rois.setCompDef(n3, new Integer(rGN.sprgn));
        } else {
            this.hi.rgn.put("t" + n + "_c" + n3, rGN);
            this.decSpec.rois.setTileCompVal(n, n3, new Integer(rGN.sprgn));
        }
        this.checkMarkerLength(dataInputStream, "RGN marker");
    }

    private void readPPM(DataInputStream dataInputStream) throws IOException {
        if (this.pPMMarkerData == null) {
            this.pPMMarkerData = new byte[this.nPPMMarkSeg][];
            this.tileOfTileParts = new Vector();
            this.decSpec.pphs.setDefault(new Boolean(true));
        }
        int n = dataInputStream.readUnsignedShort();
        int n2 = n - 3;
        int n3 = dataInputStream.readUnsignedByte();
        this.pPMMarkerData[n3] = new byte[n2];
        dataInputStream.read(this.pPMMarkerData[n3], 0, n2);
        this.checkMarkerLength(dataInputStream, "PPM marker");
    }

    private void readPPT(DataInputStream dataInputStream, int n, int n2) throws IOException {
        boolean bl = false;
        if (this.tilePartPkdPktHeaders == null) {
            this.tilePartPkdPktHeaders = new byte[this.nTiles][][][];
        }
        if (this.tilePartPkdPktHeaders[n] == null) {
            this.tilePartPkdPktHeaders[n] = new byte[this.nTileParts[n]][][];
        }
        if (this.tilePartPkdPktHeaders[n][n2] == null) {
            this.tilePartPkdPktHeaders[n][n2] = new byte[this.nPPTMarkSeg[n][n2]][];
        }
        int n3 = dataInputStream.readUnsignedShort();
        int n4 = dataInputStream.readUnsignedByte();
        byte[] byArray = new byte[n3 - 3];
        dataInputStream.read(byArray);
        this.tilePartPkdPktHeaders[n][n2][n4] = byArray;
        this.checkMarkerLength(dataInputStream, "PPT marker");
        this.decSpec.pphs.setTileDef(n, new Boolean(true));
    }

    private void extractMainMarkSeg(short s, RandomAccessIO randomAccessIO) throws IOException {
        if (this.nfMarkSeg == 0 && s != -175) {
            throw new CorruptedCodestreamException("First marker after SOC must be SIZ " + Integer.toHexString(s));
        }
        String string = "";
        if (this.ht == null) {
            this.ht = new Hashtable();
        }
        switch (s) {
            case -175: {
                if ((this.nfMarkSeg & 1) != 0) {
                    throw new CorruptedCodestreamException("More than one SIZ marker segment found in main header");
                }
                this.nfMarkSeg |= 1;
                string = "SIZ";
                break;
            }
            case -109: {
                throw new CorruptedCodestreamException("SOD found in main header");
            }
            case -39: {
                throw new CorruptedCodestreamException("EOC found in main header");
            }
            case -112: {
                if ((this.nfMarkSeg & 0x40) != 0) {
                    throw new CorruptedCodestreamException("More than one SOT marker found right after main or tile header");
                }
                this.nfMarkSeg |= 0x40;
                return;
            }
            case -174: {
                if ((this.nfMarkSeg & 2) != 0) {
                    throw new CorruptedCodestreamException("More than one COD marker found in main header");
                }
                this.nfMarkSeg |= 2;
                string = "COD";
                break;
            }
            case -173: {
                this.nfMarkSeg |= 4;
                string = "COC" + this.nCOCMarkSeg++;
                break;
            }
            case -164: {
                if ((this.nfMarkSeg & 8) != 0) {
                    throw new CorruptedCodestreamException("More than one QCD marker found in main header");
                }
                this.nfMarkSeg |= 8;
                string = "QCD";
                break;
            }
            case -163: {
                this.nfMarkSeg |= 0x100;
                string = "QCC" + this.nQCCMarkSeg++;
                break;
            }
            case -162: {
                this.nfMarkSeg |= 0x200;
                string = "RGN" + this.nRGNMarkSeg++;
                break;
            }
            case -156: {
                this.nfMarkSeg |= 0x800;
                string = "COM" + this.nCOMMarkSeg++;
                break;
            }
            case -157: {
                if ((this.nfMarkSeg & 0x10000) != 0) {
                    throw new CorruptedCodestreamException("More than one CRG marker found in main header");
                }
                this.nfMarkSeg |= 0x10000;
                string = "CRG";
                break;
            }
            case -160: {
                this.nfMarkSeg |= 0x4000;
                string = "PPM" + this.nPPMMarkSeg++;
                break;
            }
            case -171: {
                if ((this.nfMarkSeg & 0x10) != 0) {
                    throw new CorruptedCodestreamException("More than one TLM marker found in main header");
                }
                this.nfMarkSeg |= 0x10;
                break;
            }
            case -169: {
                if ((this.nfMarkSeg & 0x20) != 0) {
                    throw new CorruptedCodestreamException("More than one PLM marker found in main header");
                }
                FacilityManager.getMsgLogger().printmsg(2, "PLM marker segment found but not used by by JJ2000 decoder.");
                this.nfMarkSeg |= 0x20;
                string = "PLM";
                break;
            }
            case -161: {
                if ((this.nfMarkSeg & 0x400) != 0) {
                    throw new CorruptedCodestreamException("More than one POC marker segment found in main header");
                }
                this.nfMarkSeg |= 0x400;
                string = "POC";
                break;
            }
            case -168: {
                throw new CorruptedCodestreamException("PLT found in main header");
            }
            case -159: {
                throw new CorruptedCodestreamException("PPT found in main header");
            }
            default: {
                string = "UNKNOWN";
                FacilityManager.getMsgLogger().printmsg(2, "Non recognized marker segment (0x" + Integer.toHexString(s) + ") in main header!");
            }
        }
        if (s < -208 || s > -193) {
            int n = randomAccessIO.readUnsignedShort();
            byte[] byArray = new byte[n];
            byArray[0] = (byte)(n >> 8 & 0xFF);
            byArray[1] = (byte)(n & 0xFF);
            randomAccessIO.readFully(byArray, 2, n - 2);
            if (!string.equals("UNKNOWN")) {
                this.ht.put(string, byArray);
            }
        }
    }

    public void extractTilePartMarkSeg(short s, RandomAccessIO randomAccessIO, int n, int n2) throws IOException {
        String string = "";
        if (this.ht == null) {
            this.ht = new Hashtable();
        }
        switch (s) {
            case -112: {
                throw new CorruptedCodestreamException("Second SOT marker segment found in tile-part header");
            }
            case -175: {
                throw new CorruptedCodestreamException("SIZ found in tile-part header");
            }
            case -39: {
                throw new CorruptedCodestreamException("EOC found in tile-part header");
            }
            case -171: {
                throw new CorruptedCodestreamException("TLM found in tile-part header");
            }
            case -169: {
                throw new CorruptedCodestreamException("PLM found in tile-part header");
            }
            case -160: {
                throw new CorruptedCodestreamException("PPM found in tile-part header");
            }
            case -174: {
                if ((this.nfMarkSeg & 2) != 0) {
                    throw new CorruptedCodestreamException("More than one COD marker found in tile-part header");
                }
                this.nfMarkSeg |= 2;
                string = "COD";
                break;
            }
            case -173: {
                this.nfMarkSeg |= 4;
                string = "COC" + this.nCOCMarkSeg++;
                break;
            }
            case -164: {
                if ((this.nfMarkSeg & 8) != 0) {
                    throw new CorruptedCodestreamException("More than one QCD marker found in tile-part header");
                }
                this.nfMarkSeg |= 8;
                string = "QCD";
                break;
            }
            case -163: {
                this.nfMarkSeg |= 0x100;
                string = "QCC" + this.nQCCMarkSeg++;
                break;
            }
            case -162: {
                this.nfMarkSeg |= 0x200;
                string = "RGN" + this.nRGNMarkSeg++;
                break;
            }
            case -156: {
                this.nfMarkSeg |= 0x800;
                string = "COM" + this.nCOMMarkSeg++;
                break;
            }
            case -157: {
                throw new CorruptedCodestreamException("CRG marker found in tile-part header");
            }
            case -159: {
                this.nfMarkSeg |= 0x8000;
                if (this.nPPTMarkSeg == null) {
                    this.nPPTMarkSeg = new int[this.nTiles][];
                }
                if (this.nPPTMarkSeg[n] == null) {
                    this.nPPTMarkSeg[n] = new int[this.nTileParts[n]];
                }
                int[] nArray = this.nPPTMarkSeg[n];
                int n3 = n2;
                int n4 = nArray[n3];
                nArray[n3] = n4 + 1;
                string = "PPT" + n4;
                break;
            }
            case -109: {
                this.nfMarkSeg |= 0x2000;
                return;
            }
            case -161: {
                if ((this.nfMarkSeg & 0x400) != 0) {
                    throw new CorruptedCodestreamException("More than one POC marker segment found in tile-part header");
                }
                this.nfMarkSeg |= 0x400;
                string = "POC";
                break;
            }
            case -168: {
                if ((this.nfMarkSeg & 0x20) != 0) {
                    throw new CorruptedCodestreamException("PLT marker found eventhough PLM marker found in main header");
                }
                FacilityManager.getMsgLogger().printmsg(2, "PLT marker segment found but not used by JJ2000 decoder.");
                string = "UNKNOWN";
                break;
            }
            default: {
                string = "UNKNOWN";
                FacilityManager.getMsgLogger().printmsg(2, "Non recognized marker segment (0x" + Integer.toHexString(s) + ") in tile-part header" + " of tile " + n + " !");
            }
        }
        int n5 = randomAccessIO.readUnsignedShort();
        byte[] byArray = new byte[n5];
        byArray[0] = (byte)(n5 >> 8 & 0xFF);
        byArray[1] = (byte)(n5 & 0xFF);
        randomAccessIO.readFully(byArray, 2, n5 - 2);
        if (!string.equals("UNKNOWN")) {
            this.ht.put(string, byArray);
        }
    }

    private void readFoundMainMarkSeg() throws IOException {
        int n;
        ByteArrayInputStream byteArrayInputStream;
        if ((this.nfMarkSeg & 1) != 0) {
            byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("SIZ"));
            this.readSIZ(new DataInputStream(byteArrayInputStream));
        }
        if ((this.nfMarkSeg & 0x800) != 0) {
            for (n = 0; n < this.nCOMMarkSeg; ++n) {
                byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("COM" + n));
                this.readCOM(new DataInputStream(byteArrayInputStream), true, 0, n);
            }
        }
        if ((this.nfMarkSeg & 0x10000) != 0) {
            byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("CRG"));
            this.readCRG(new DataInputStream(byteArrayInputStream));
        }
        if ((this.nfMarkSeg & 2) != 0) {
            byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("COD"));
            this.readCOD(new DataInputStream(byteArrayInputStream), true, 0, 0);
        }
        if ((this.nfMarkSeg & 4) != 0) {
            for (n = 0; n < this.nCOCMarkSeg; ++n) {
                byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("COC" + n));
                this.readCOC(new DataInputStream(byteArrayInputStream), true, 0, 0);
            }
        }
        if ((this.nfMarkSeg & 0x200) != 0) {
            for (n = 0; n < this.nRGNMarkSeg; ++n) {
                byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("RGN" + n));
                this.readRGN(new DataInputStream(byteArrayInputStream), true, 0, 0);
            }
        }
        if ((this.nfMarkSeg & 8) != 0) {
            byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("QCD"));
            this.readQCD(new DataInputStream(byteArrayInputStream), true, 0, 0);
        }
        if ((this.nfMarkSeg & 0x100) != 0) {
            for (n = 0; n < this.nQCCMarkSeg; ++n) {
                byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("QCC" + n));
                this.readQCC(new DataInputStream(byteArrayInputStream), true, 0, 0);
            }
        }
        if ((this.nfMarkSeg & 0x400) != 0) {
            byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("POC"));
            this.readPOC(new DataInputStream(byteArrayInputStream), true, 0, 0);
        }
        if ((this.nfMarkSeg & 0x4000) != 0) {
            for (n = 0; n < this.nPPMMarkSeg; ++n) {
                byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("PPM" + n));
                this.readPPM(new DataInputStream(byteArrayInputStream));
            }
        }
        this.ht = null;
    }

    public void readFoundTilePartMarkSeg(int n, int n2) throws IOException {
        int n3;
        ByteArrayInputStream byteArrayInputStream;
        if ((this.nfMarkSeg & 2) != 0) {
            byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("COD"));
            this.readCOD(new DataInputStream(byteArrayInputStream), false, n, n2);
        }
        if ((this.nfMarkSeg & 4) != 0) {
            for (n3 = 0; n3 < this.nCOCMarkSeg; ++n3) {
                byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("COC" + n3));
                this.readCOC(new DataInputStream(byteArrayInputStream), false, n, n2);
            }
        }
        if ((this.nfMarkSeg & 0x200) != 0) {
            for (n3 = 0; n3 < this.nRGNMarkSeg; ++n3) {
                byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("RGN" + n3));
                this.readRGN(new DataInputStream(byteArrayInputStream), false, n, n2);
            }
        }
        if ((this.nfMarkSeg & 8) != 0) {
            byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("QCD"));
            this.readQCD(new DataInputStream(byteArrayInputStream), false, n, n2);
        }
        if ((this.nfMarkSeg & 0x100) != 0) {
            for (n3 = 0; n3 < this.nQCCMarkSeg; ++n3) {
                byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("QCC" + n3));
                this.readQCC(new DataInputStream(byteArrayInputStream), false, n, n2);
            }
        }
        if ((this.nfMarkSeg & 0x400) != 0) {
            byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("POC"));
            this.readPOC(new DataInputStream(byteArrayInputStream), false, n, n2);
        }
        if ((this.nfMarkSeg & 0x800) != 0) {
            for (n3 = 0; n3 < this.nCOMMarkSeg; ++n3) {
                byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("COM" + n3));
                this.readCOM(new DataInputStream(byteArrayInputStream), false, n, n3);
            }
        }
        if ((this.nfMarkSeg & 0x8000) != 0) {
            for (n3 = 0; n3 < this.nPPTMarkSeg[n][n2]; ++n3) {
                byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("PPT" + n3));
                this.readPPT(new DataInputStream(byteArrayInputStream), n, n2);
            }
        }
        this.ht = null;
    }

    public DecoderSpecs getDecoderSpecs() {
        return this.decSpec;
    }

    public HeaderDecoder(RandomAccessIO randomAccessIO, ParameterList parameterList, HeaderInfo headerInfo) throws IOException {
        this.hi = headerInfo;
        this.verbose = this.verbose;
        parameterList.checkList('H', ParameterList.toNameArray(pinfo));
        this.mainHeadOff = randomAccessIO.getPos();
        if (randomAccessIO.readShort() != -177) {
            throw new CorruptedCodestreamException("SOC marker segment not  found at the beginning of the codestream.");
        }
        this.nfMarkSeg = 0;
        do {
            this.extractMainMarkSeg(randomAccessIO.readShort(), randomAccessIO);
        } while ((this.nfMarkSeg & 0x40) == 0);
        randomAccessIO.seek(randomAccessIO.getPos() - 2);
        this.readFoundMainMarkSeg();
    }

    public EntropyDecoder createEntropyDecoder(CodedCBlkDataSrcDec codedCBlkDataSrcDec, ParameterList parameterList) {
        parameterList.checkList('C', ParameterList.toNameArray(EntropyDecoder.getParameterInfo()));
        boolean bl = parameterList.getBooleanParameter("Cer");
        boolean bl2 = parameterList.getBooleanParameter("Cverber");
        int n = parameterList.getIntParameter("m_quit");
        return new StdEntropyDecoder(codedCBlkDataSrcDec, this.decSpec, bl, bl2, n);
    }

    public BlkImgDataSrc createColorSpaceMapper(BlkImgDataSrc blkImgDataSrc, ColorSpace colorSpace) throws IOException, ICCProfileException, ColorSpaceException {
        return ColorSpaceMapper.createInstance(blkImgDataSrc, colorSpace);
    }

    public BlkImgDataSrc createChannelDefinitionMapper(BlkImgDataSrc blkImgDataSrc, ColorSpace colorSpace) throws IOException, ColorSpaceException {
        return ChannelDefinitionMapper.createInstance(blkImgDataSrc, colorSpace);
    }

    public BlkImgDataSrc createPalettizedColorSpaceMapper(BlkImgDataSrc blkImgDataSrc, ColorSpace colorSpace) throws IOException, ColorSpaceException {
        return PalettizedColorSpaceMapper.createInstance(blkImgDataSrc, colorSpace);
    }

    public BlkImgDataSrc createResampler(BlkImgDataSrc blkImgDataSrc, ColorSpace colorSpace) throws IOException, ColorSpaceException {
        return Resampler.createInstance(blkImgDataSrc, colorSpace);
    }

    public ROIDeScaler createROIDeScaler(CBlkQuantDataSrcDec cBlkQuantDataSrcDec, ParameterList parameterList, DecoderSpecs decoderSpecs) {
        return ROIDeScaler.createInstance(cBlkQuantDataSrcDec, parameterList, decoderSpecs);
    }

    public void resetHeaderMarkers() {
        this.nfMarkSeg &= 0x4020;
        this.nCOCMarkSeg = 0;
        this.nQCCMarkSeg = 0;
        this.nCOMMarkSeg = 0;
        this.nRGNMarkSeg = 0;
    }

    public String toString() {
        return this.hdStr;
    }

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    public int getNumTiles() {
        return this.nTiles;
    }

    public ByteArrayInputStream getPackedPktHead(int n) throws IOException {
        block8: {
            int n2;
            if (this.pkdPktHeaders != null) break block8;
            this.pkdPktHeaders = new ByteArrayOutputStream[this.nTiles];
            for (n2 = this.nTiles - 1; n2 >= 0; --n2) {
                this.pkdPktHeaders[n2] = new ByteArrayOutputStream();
            }
            if (this.nPPMMarkSeg != 0) {
                int n3 = this.tileOfTileParts.size();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                for (n2 = 0; n2 < this.nPPMMarkSeg; ++n2) {
                    byteArrayOutputStream.write(this.pPMMarkerData[n2]);
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                for (n2 = 0; n2 < n3; ++n2) {
                    int n4 = (Integer)this.tileOfTileParts.elementAt(n2);
                    int n5 = byteArrayInputStream.read() << 24 | byteArrayInputStream.read() << 16 | byteArrayInputStream.read() << 8 | byteArrayInputStream.read();
                    byte[] byArray = new byte[n5];
                    byteArrayInputStream.read(byArray);
                    this.pkdPktHeaders[n4].write(byArray);
                }
            } else {
                for (int i = this.nTiles - 1; i >= 0; --i) {
                    for (int j = 0; j < this.nTileParts[i]; ++j) {
                        for (n2 = 0; n2 < this.nPPTMarkSeg[i][j]; ++n2) {
                            this.pkdPktHeaders[i].write(this.tilePartPkdPktHeaders[i][j][n2]);
                        }
                    }
                }
            }
        }
        return new ByteArrayInputStream(this.pkdPktHeaders[n].toByteArray());
    }

    public void setTileOfTileParts(int n) {
        if (this.nPPMMarkSeg != 0) {
            this.tileOfTileParts.addElement(new Integer(n));
        }
    }

    public int getNumFoundMarkSeg() {
        return this.nfMarkSeg;
    }
}

