package nashid.verify.sdk.di

import android.app.Activity
import android.app.Application
import android.os.Bundle
import nashid.verify.sdk.utils.KoinEnvironment

class MyApp : Application() {
    private var currentActivity: Activity? = null

    override fun onCreate() {
        super.onCreate()
        KoinEnvironment.initKoin(this)
        // Register activity lifecycle callbacks to track the current activity
        registerActivityLifecycleCallbacks(
            object : Application.ActivityLifecycleCallbacks {
                override fun onActivityCreated(
                    activity: Activity,
                    savedInstanceState: Bundle?,
                ) {
                    currentActivity = activity
                }

                override fun onActivityStarted(activity: Activity) {}

                override fun onActivityResumed(activity: Activity) {}

                override fun onActivityPaused(activity: Activity) {}

                override fun onActivityStopped(activity: Activity) {}

                override fun onActivitySaveInstanceState(
                    activity: Activity,
                    outState: Bundle,
                ) {}

                override fun onActivityDestroyed(activity: Activity) {
                    if (currentActivity == activity) {
                        currentActivity = null
                    }
                }
            },
        )
    }

    // Method to finish the current activity
    fun finishCurrentActivity() {
        currentActivity?.finish()
    }
}
