package nashid.verify.sdk.model

import com.google.gson.TypeAdapter
import com.google.gson.stream.JsonReader
import com.google.gson.stream.JsonWriter

class ExtraDataTypeAdapter : TypeAdapter<ExtraData>() {
    override fun write(
        out: JsonWriter,
        value: ExtraData?,
    ) {
        if (value == null) {
            out.nullValue()
            return
        }

        out.beginObject()
        value.toMap().forEach { (key, value) ->
            out.name(key)
            when (value) {
                is String -> out.value(value)
                is Number -> out.value(value)
                is Boolean -> out.value(value)
                else -> out.value(value.toString())
            }
        }
        out.endObject()
    }

    override fun read(reader: JsonReader): ExtraData {
        val map = mutableMapOf<String, Any>()
        reader.beginObject()
        while (reader.hasNext()) {
            map[reader.nextName()] = reader.nextString()
        }
        reader.endObject()
        return ExtraData(map)
    }
}
