package nashid.verify.sdk.utils.helpers

import android.graphics.Bitmap
import android.util.Log
import com.google.mlkit.vision.common.InputImage
import com.google.mlkit.vision.face.FaceDetection
import com.google.mlkit.vision.face.FaceDetectorOptions

class FaceDetectionUtil {
    companion object {
        fun cropFaceFromIDCard(
            idCardBitmap: Bitmap,
            onComplete: (Bitmap?) -> Unit,
        ) {
            try {
                val options =
                    FaceDetectorOptions.Builder()
                        .setPerformanceMode(FaceDetectorOptions.PERFORMANCE_MODE_ACCURATE)
                        .setLandmarkMode(FaceDetectorOptions.LANDMARK_MODE_ALL)
                        .setClassificationMode(FaceDetectorOptions.CLASSIFICATION_MODE_ALL)
                        .build()

                val detector = FaceDetection.getClient(options)
                val image = InputImage.fromBitmap(idCardBitmap, 0)
                detector.process(image)
                    .addOnSuccessListener { faces ->
                        if (faces.size > 0) {
                            val face = faces[0]
                            val bounds = face.boundingBox
                            val padding = 0.2f
                            val newLeft = (bounds.left - bounds.width() * padding).toInt().coerceAtLeast(0)
                            val newTop = (bounds.top - bounds.height() * padding).toInt().coerceAtLeast(0)
                            val newRight = (bounds.right + bounds.width() * padding).toInt().coerceAtMost(idCardBitmap.width)
                            val newBottom = (bounds.bottom + bounds.height() * padding).toInt().coerceAtMost(idCardBitmap.height)
                            val croppedBitmap =
                                Bitmap.createBitmap(
                                    idCardBitmap,
                                    newLeft,
                                    newTop,
                                    newRight - newLeft,
                                    newBottom - newTop,
                                )
                            onComplete(croppedBitmap)
                        } else {
                            onComplete(null)
                        }
                    }
                    .addOnFailureListener { e ->
                        Log.e("FaceDetection", "Face detection failed", e)
                        onComplete(null)
                    }
            } catch (e: Exception) {
                Log.e("FaceDetection", "Error processing image", e)
                onComplete(null)
            }
        }
    }
}
