package nashid.verify.sdk.utils

internal object Constants {
    // Base URL for the API
    const val BASE_URL_STAGING = "https://api-staging.nashid.io/api/v1/tenant/sdk/"
    const val BASE_URL_PRODUCTION = "https://api.nashid.io/api/v1/tenant/sdk/"

    //
    const val APP_KEY_STAGING = "staging"
    const val APP_KEY_PRODUCTION = "oAmH90FAc7yP54lwJBk4BhpLUk0Nv8iQ"

    // Passport regex patterns
    const val PASSPORT_TD_3_LINE_1_REGEX =
        "(P[A-Z0-9<]{1})([A-Z]{3})([A-Z0-9<]{39})"
    const val PASSPORT_TD_3_LINE_2_REGEX =
        "([A-Z0-9<]{9})([0-9]{1})([A-Z]{3})([0-9]{6})([0-9]{1})([M|F|X|<]{1})([0-9]{6})([0-9]{1})"

    // ID Card regex patterns
    const val ID_CARD_REGEX1 =
        "([A|C|I][A-Z0-9<K]{1})([A-Z]{3})([A-Z0-9<]{9})([0-9]{1})"
    const val ID_CARD_REGEX2 =
        "([0-9]{6})([0-9]{1})([MFX]{1})([0-9]{6})([0-9]{1})([A-Z]{3})([A-Z0-9<]{11})([A-Z0-9<]{1})"
    const val ID_CARD_REGEX3 =
        "([A-Z]+)<([A-Z<]+)"

    // Offsets for various drawing and API operations
    const val DRAW_SQUARE_OFFSET = 0.06
    const val VISION_API_OFFSET = 0.06

    // Date formats
    const val DATE_FORMAT = "yyyy-dd-MM"
    const val PASSPORT_DATE_FORMAT = "dd MMM yyyy"

    // Configuration flags
    const val IS_ACTIVE_LIVENESS_ENABLED = false
}
