package nashid.verify.sdk.di

import com.google.mlkit.vision.text.TextRecognition
import com.google.mlkit.vision.text.latin.TextRecognizerOptions
import nashid.verify.sdk.data.repository.AuthRepository
import nashid.verify.sdk.data.repository.IdCardRepository
import nashid.verify.sdk.data.repository.NfcRepository
import nashid.verify.sdk.data.repository.PassportRepository
import nashid.verify.sdk.data.repository.ScanDocumentRepository
import nashid.verify.sdk.data.repository.SkipLiveNessRepository
import nashid.verify.sdk.utils.ScanDocument
import nashid.verify.sdk.utils.helpers.Storage
import nashid.verify.sdk.utils.helpers.TextSizeConverter
import nashid.verify.sdk.viewmodel.AuthViewModel
import nashid.verify.sdk.viewmodel.CameraXLiveData
import nashid.verify.sdk.viewmodel.CameraXLiveViewModel
import nashid.verify.sdk.viewmodel.NFCViewModel
import nashid.verify.sdk.viewmodel.NfcLiveData
import nashid.verify.sdk.viewmodel.ScanDocumentViewModel
import nashid.verify.sdk.viewmodel.SkipNfcLiveNessLiveData
import nashid.verify.sdk.viewmodel.SkipNfcLiveNessViewModel
import org.koin.android.ext.koin.androidApplication
import org.koin.android.ext.koin.androidContext
import org.koin.androidx.viewmodel.dsl.viewModel
import org.koin.dsl.module

val AppModule =
    module {
        // Other dependencies
        single { provideHttpClient() }
        single { provideConverterFactory() }
        single { provideRetrofit(get(), get()) }
        single { provideService(get()) }

        // Repositories
        single { AuthRepository(get(), androidContext()) }
        single { NfcRepository(get(), androidContext()) }
        single { IdCardRepository(get(), get()) }
        single { PassportRepository(get(), get(), androidContext()) }
        single { SkipLiveNessRepository(get(), androidContext()) }

        // ViewModels
        viewModel { AuthViewModel(get()) }
        viewModel { CameraXLiveViewModel(get(), get(), androidApplication(), get(), get(), get()) }
        viewModel { NFCViewModel(get(), androidApplication(), get()) }
        viewModel { SkipNfcLiveNessViewModel(get(), get(), androidApplication(), get()) }
        viewModel { ScanDocumentViewModel(get(), androidApplication()) }

        // Other classes
        single { TextRecognition.getClient(TextRecognizerOptions.DEFAULT_OPTIONS) }
        single { CameraXLiveData() }
        single { NfcLiveData() }
        single { SkipNfcLiveNessLiveData() }
        single { TextSizeConverter(get()) }
        single { ScanDocument.getInstance() }
        single { Storage(get()) }

        // Repositories for scan document
        single { ScanDocumentRepository(get(), androidContext()) }
    }
