package nashid.verify.sdk.utils

import nashid.verify.sdk.model.VerificationResultData

data class ScanDocument(
    var documentNo: String? = null,
    var dateOfBirth: String? = null,
    var expiryDate: String? = null,
    var verificationResult: VerificationResultData? = null,
) {
    companion object {
        @Volatile
        private var scanDocument: ScanDocument? = null

        fun getInstance(): ScanDocument {
            return scanDocument ?: synchronized(this) {
                scanDocument ?: ScanDocument().also { scanDocument = it }
            }
        }
    }

    override fun toString(): String {
        return "ScanDocument(documentNo=$documentNo, dateOfBirth=$dateOfBirth, expiryDate=$expiryDate)"
    }
}
