package nashid.verify.sdk.utils

import android.util.Log
import nashid.verify.sdkNew.BuildConfig

object Loggers {
    private const val DEFAULT_PRIORITY = Log.DEBUG

    fun withTag(tag: String): LoggerInstance {
        return LoggerInstance(tag, DEFAULT_PRIORITY)
    }

    class LoggerInstance(private val tag: String, private val priority: Int) {
        fun log(message: String) {
            if (BuildConfig.DEBUG) {
                Log.println(priority, tag, message)
            }
        }

        fun withCause(cause: Exception) {
            // Uncomment the following line to log only in debug mode
            // if (BuildConfig.DEBUG) {
            Log.println(priority, tag, Log.getStackTraceString(cause))
            // }
        }
    }
}
