package nashid.verify.sdk.data.repository

import nashid.verify.sdk.utils.Constants.ID_CARD_REGEX1
import nashid.verify.sdk.utils.Constants.ID_CARD_REGEX2
import nashid.verify.sdk.utils.Constants.ID_CARD_REGEX3
import nashid.verify.sdk.utils.ScanDocument
import nashid.verify.sdk.utils.helpers.OmanIdCardReaderHelper.Companion.cleanString
import nashid.verify.sdk.utils.helpers.OmanIdCardReaderHelper.Companion.isSimilarEnough
import nashid.verify.sdk.utils.helpers.OmanIdCardReaderHelper.Companion.replaceAlfaWithNumber
import nashid.verify.sdk.utils.helpers.OmanIdCardReaderHelper.Companion.replaceNumberWithAlfa
import nashid.verify.sdk.utils.helpers.Utility
import nashid.verify.sdk.viewmodel.CameraXLiveData
import java.util.Locale
import java.util.Objects
import java.util.regex.Pattern

class IdCardRepository(
    private val cameraXLiveData: CameraXLiveData,
    private val scanDocument: ScanDocument,
) {
    fun readIdCardBackView(textAll: Array<String>) {
        var gender = ""
        val pattern1 = Pattern.compile(ID_CARD_REGEX1)
        val pattern2 = Pattern.compile(ID_CARD_REGEX2)
        val pattern3 = Pattern.compile(ID_CARD_REGEX3)
        if (cameraXLiveData.getAlgoHeaderDetect().value == false) {
            if (isSimilarEnough(java.lang.String.join(" ", *textAll))) {
                cameraXLiveData.setAlgoHeaderDetect(true)
            }
        }
        if (cameraXLiveData.getAlgoHeaderDetect().value == true) {
            if (cameraXLiveData.getIdLine3().value == true) {
                var validLine3Found = false
                for (data in textAll) {
                    var updatedString = StringBuilder(data.replace(" ", ""))
                    val removeKString = removeKValueFromString(updatedString.toString())
                    updatedString = StringBuilder(removeKString.replace("«", "<"))
                    val matcher3 = pattern3.matcher(updatedString.toString())
                    if (matcher3.matches()) {
                        val originalName = updatedString.toString().replace("<", " ").replace("«", " ").trim()
                        val nameParts = originalName.split(" ")
                        val formattedName = StringBuilder()
                        formattedName.append(nameParts[0])
                        formattedName.append("<")
                        for (i in 1 until nameParts.size) {
                            formattedName.append(nameParts[i])
                            if (i < nameParts.size - 1) {
                                formattedName.append("<")
                            }
                        }
                        while (formattedName.length < 30) {
                            formattedName.append("<")
                        }
                        if (formattedName.length == 30) {
                            Utility.getInstance().name = originalName
                            Utility.getInstance().mrzLine3 = formattedName.toString()
                            cameraXLiveData.setIdLine3(false)
                            validLine3Found = true
                            break
                        }
                    }
                }
                if (!validLine3Found) {
                    cameraXLiveData.setIsSuccess(false)
                    return
                }
            }
            if (cameraXLiveData.getIdLine3().value == false) {
                for (data in textAll) {
                    var updatedString = StringBuilder(data.replace(" ", ""))
                    val removeKString = removeKValueFromString(updatedString.toString())
                    updatedString = StringBuilder(removeKString.replace("«", "<"))
                    val matcher3 = pattern3.matcher(updatedString.toString())
                    val name = StringBuilder(data.replace("NAME ", "").replace(" ", "<"))

                    // reading person name MRZ
                    if (matcher3.matches() && cameraXLiveData.getIdLine3().value == true) {
                        // Store the original name without extra formatting
                        Utility.getInstance().name = updatedString.toString().replace("<", " ").replace("«", " ").trim()

                        // Format name for MRZ line 3 with proper padding
                        val nameParts = Utility.getInstance().name?.split(" ") ?: listOf()
                        val formattedName = StringBuilder()

                        // Add first name
                        formattedName.append(nameParts.getOrNull(0) ?: "")
                        formattedName.append("<")

                        // Add remaining name parts
                        for (i in 1 until (nameParts.size)) {
                            formattedName.append(nameParts[i])
                            if (i < nameParts.size - 1) {
                                formattedName.append("<")
                            }
                        }

                        // Pad with '<' to reach 30 characters
                        while (formattedName.length < 30) {
                            formattedName.append("<")
                        }

                        Utility.getInstance().mrzLine3 = formattedName.toString()
                        cameraXLiveData.setIdLine3(false)
                    }
                    val index = updatedString.indexOf("MN")
                    var replacedString = updatedString.toString()
                    // Replace the 0 with O if MRZ contain MN(OMN) string
                    if (index > 1 && updatedString[index - 1] == '0') {
                        val firstPart =
                            updatedString.substring(
                                0,
                                index - 1,
                            ) // Exclude the character before "MN"
                        var secondPart = updatedString.substring(index - 1) // Include "MN" and the rest of the string
                        if (secondPart.startsWith("0")) {
                            secondPart = secondPart.replace("0", "O") // Replace "O0" with "00"
                        }
                        replacedString = firstPart + secondPart // Concatenate the two parts back together
                    }
                    // replace the text at last position of string if last letter is char instead of digit
                    val lastChar = replacedString[replacedString.length - 1]
                    if (Character.isLetter(lastChar)) {
                        if (lastChar == 'O' || lastChar == 'o') {
                            replacedString = replacedString.substring(0, replacedString.length - 1) + '0'
                        }
                    }
                    if (replacedString.length >= 25) {
                        replacedString = addCharactersToReachLength(replacedString, 30)
                    }
                    val matcher2 = pattern2.matcher(cleanString(replacedString))
                    var matcherString: String? = updatedString.toString()
                    if (updatedString.length > 15) {
                        matcherString = updatedString.substring(0, 15)
                    }

                    // Reading the MRZ1 line
                    val matcher1 = pattern1.matcher(matcherString.toString())
                    if (matcher1.matches() && cameraXLiveData.getIdLine1().value == true) {
                        val length = 30 - updatedString.length
                        for (i in 0 until length) {
                            updatedString.append("<")
                        }
                        Utility.getInstance().mrzLine1 = updatedString.toString()
                        cameraXLiveData.setIdNo(
                            replaceAlfaWithNumber(
                                Objects.requireNonNull(
                                    matcher1.group(3),
                                ),
                            ),
                        )
                        val country = replaceNumberWithAlfa(Objects.requireNonNull(matcher1.group(2)))
                        Utility.getInstance().country = country
                        Utility.getInstance().documentType = matcher1.group(1)
                        cameraXLiveData.setIdLine1(false)
                    }
                    // Reading MRZLine 2
                    if (replacedString.length == 30 && matcher2.matches() && cameraXLiveData.getIdLine2().value == true) {
                        updatedString = StringBuilder(cleanString(replacedString))
                        Utility.getInstance().mrzLine2 = updatedString.toString()
                        cameraXLiveData.setDOB(matcher2.group(1))
                        cameraXLiveData.setExpiryDate(matcher2.group(4))
                        val rawGender = matcher2.group(3)?.toString()?.trim()?.uppercase()
                        gender =
                            when (rawGender) {
                                "F", "E" -> "F" // Sometimes OCR might read F as E
                                "M" -> "M"
                                "X" -> "X"
                                else -> {
                                    ""
                                }
                            }

                        Utility.getInstance().gender = gender
                        val nationality = matcher2.group(6)
                        Utility.getInstance().nationality = nationality
                        cameraXLiveData.setIdLine2(false)
                    }
                    if (cameraXLiveData.getIdLine1().value == false && cameraXLiveData.getIdLine2().value == false && cameraXLiveData.getIdLine3().value == false) {
                        break
                    }
                }
            }
        }
        //        will call this line when successfully read all MRZLines
        if (Utility.getInstance().mrzLine1 != null && Utility.getInstance().mrzLine2 != null && Utility.getInstance().mrzLine3 != null) {
            if (cameraXLiveData.getIsFrontViewScanned().value == false) {
                cameraXLiveData.setIdNo(null)
                cameraXLiveData.setDOB(null)
                cameraXLiveData.setExpiryDate(null)
                cameraXLiveData.setIdLine1(true)
                cameraXLiveData.setIdLine2(true)
                cameraXLiveData.setIdLine3(true)
                cameraXLiveData.setIsSuccess(false)
                //                isSuccess = false;
            } else if (cameraXLiveData.getExpiryDate().value != null && cameraXLiveData.getExpiryDate().value!!.isNotEmpty()) {
                if (cameraXLiveData.getIsFrontViewScanned().value == true &&
                    Objects.requireNonNull<String?>(
                        cameraXLiveData.getIdNo().value,
                    ).isNotEmpty() &&
                    Objects.requireNonNull<String?>(
                        cameraXLiveData.dOB.value,
                    ).isNotEmpty()
                ) {
                    val documentNumber = cameraXLiveData.getIdNo().value
                    val dateOfBirthDay = cameraXLiveData.dOB.value
                    val expiryDate = cameraXLiveData.getExpiryDate().value
                    try {
                        if (expiryDate!!.isNotEmpty()) {
                            scanDocument.documentNo = documentNumber
                            scanDocument.dateOfBirth = dateOfBirthDay
                            scanDocument.expiryDate = expiryDate
                            Utility.getInstance().passportNumber = documentNumber
                            Utility.getInstance().dateOfBirth = dateOfBirthDay
                            Utility.getInstance().expiryDate = expiryDate
                            Utility.getInstance().gender = gender.uppercase()
                            cameraXLiveData.setFlag(false)
                            cameraXLiveData.setCloseAnalysisUseCase(true)
                            cameraXLiveData.setIsSuccess(true)
                            cameraXLiveData.setCTimer(true)
                            cameraXLiveData.setCaptureAnImage(true)
                        } else {
                            cameraXLiveData.setIsSuccess(false)
                        }
                    } catch (e: Exception) {
                        e.printStackTrace()
                        cameraXLiveData.setIsSuccess(false)
                    }
                } else {
                    cameraXLiveData.setIsSuccess(false)
                }
            } else {
                cameraXLiveData.setIsSuccess(false)
            }
        } else {
            cameraXLiveData.setIsSuccess(false)
        }
    }

    fun readIdCardFrontView(originalText: String) {
        var text = originalText
        text = text.replace(" ", "").uppercase(Locale.getDefault())
        text = text.replace("\n", " ").uppercase(Locale.getDefault())
        if (text.contains("SULTANATEOFOMAN") && (text.contains("IDENTITY CARD") || text.contains("RESIDENT CARD"))) {
            cameraXLiveData.setIdNo(null)
            cameraXLiveData.setDOB(null)
            cameraXLiveData.setExpiryDate(null)
            cameraXLiveData.setIsFrontView(true)
            cameraXLiveData.setIdLine1(true)
            cameraXLiveData.setIdLine2(true)
            cameraXLiveData.setCaptureAnImage(true)
            cameraXLiveData.setIsSuccess(true)
        } else {
            cameraXLiveData.setIsSuccess(false)
        }
        cameraXLiveData.setCTimer(false)
    }

    private fun removeKValueFromString(modifiedMRZText: String): String {
        val latest = StringBuilder()
        for (l in modifiedMRZText.indices) {
            if (l != 0) {
                if (modifiedMRZText[l] == 'K') {
                    if (l == modifiedMRZText.length - 1) {
                        if (modifiedMRZText[l] != 'K') {
                            latest.append(modifiedMRZText[l])
                        }
                    } else {
                        if (modifiedMRZText[l - 1] != '<' && modifiedMRZText[l + 1] != '<') {
                            latest.append(modifiedMRZText[l])
                        } else {
                            if (modifiedMRZText[l - 1] != '<' || modifiedMRZText[l + 1] != '<') {
                                latest.append(modifiedMRZText[l])
                            }
                        }
                    }
                } else {
                    latest.append(modifiedMRZText[l])
                }
            } else {
                latest.append(modifiedMRZText[l])
            }
        }
        return latest.toString().replace("\\bK+\\b".toRegex(), "")
    }

    private fun addCharactersToReachLength(
        input: String,
        desiredLength: Int,
    ): String {
        if (input.length >= desiredLength) {
            return input
        }
        val lastChar = input[input.length - 1]
        if (Character.isDigit(lastChar)) {
            val additionalChars = desiredLength - input.length
            val sb = StringBuilder(input)
            for (i in 0 until additionalChars) {
                sb.insert(sb.length - 1, '<')
            }
            return sb.toString()
        }
        return input
    }
}
