package nashid.verify.sdk.model

class IDCardNFCData private constructor() {
    var identityNumber: String? = null
    var issueDate: String? = null
    var expiryDate: String? = null
    var placeOfIssueArabic: String? = null
    var placeOfIssueEnglish: String? = null
    var fullNameArabic: String? = null
    var fullNameEnglish: String? = null
    var dateOfBirth: String? = null
    var placeOfBirthArabic: String? = null
    var placeOfBirthEnglish: String? = null
    var nationalityArabic: String? = null
    var nationalityEnglish: String? = null
    var genderArabic: String? = null
    var genderEnglish: String? = null
    var visaNumber: String? = null
    var permitType: String? = null
    var useByDate: String? = null
    var visaPlaceOfIssueArabic: String? = null
    var permitNumber: String? = null
    var sponsorIssueDate: String? = null
    var sponsorExpiryDate: String? = null
    var companyNameArabic: String? = null
    var companyNameEnglish: String? = null
    var companyAddressAraic: String? = null

    override fun toString(): String {
        return "IDCardNFCData(" +
            "identityNumber='$identityNumber', " +
            "issueDate='$issueDate', " +
            "expiryDate='$expiryDate', " +
            "placeOfIssueArabic='$placeOfIssueArabic', " +
            "placeOfIssueEnglish='$placeOfIssueEnglish', " +
            "fullNameArabic='$fullNameArabic', " +
            "fullNameEnglish='$fullNameEnglish', " +
            "dateOfBirth='$dateOfBirth', " +
            "placeOfBirthArabic='$placeOfBirthArabic', " +
            "placeOfBirthEnglish='$placeOfBirthEnglish', " +
            "nationalityArabic='$nationalityArabic', " +
            "nationalityEnglish='$nationalityEnglish', " +
            "genderArabic='$genderArabic', " +
            "genderEnglish='$genderEnglish', " +
            "visaNumber='$visaNumber', " +
            "permitType='$permitType', " +
            "useByDate='$useByDate', " +
            "visaPlaceOfIssueArabic='$visaPlaceOfIssueArabic', " +
            "permitNumber='$permitNumber', " +
            "sponsorIssueDate='$sponsorIssueDate', " +
            "sponsorExpiryDate='$sponsorExpiryDate', " +
            "companyNameArabic='$companyNameArabic', " +
            "companyNameEnglish='$companyNameEnglish', " +
            "companyAddressArabic='$companyAddressAraic')"
    }

    companion object {
        @Volatile
        private var idCardNFCData: IDCardNFCData? = null

        fun getInstance(): IDCardNFCData {
            return idCardNFCData ?: synchronized(this) {
                idCardNFCData ?: IDCardNFCData().also { idCardNFCData = it }
            }
        }
    }
}
