package nashid.verify.sdk.data.repository

import android.content.Context
import android.graphics.BitmapFactory
import android.nfc.Tag
import android.nfc.tech.IsoDep
import android.util.Base64
import io.reactivex.disposables.CompositeDisposable
import nashid.verify.sdk.model.AdditionalPersonDetails
import nashid.verify.sdk.model.DocumentType
import nashid.verify.sdk.model.Passport
import nashid.verify.sdk.utils.AdditionalDGFiles
import nashid.verify.sdk.utils.DateUtil
import nashid.verify.sdk.utils.EDocument
import nashid.verify.sdk.utils.LivenessData
import nashid.verify.sdk.utils.MRTDTrustStore
import nashid.verify.sdk.utils.NFCDocumentTag
import nashid.verify.sdk.utils.PersonDetails
import nashid.verify.sdk.utils.VerificationStatus
import nashid.verify.sdk.utils.helpers.DocumentImages
import nashid.verify.sdk.utils.helpers.Utility
import nashid.verify.sdk.utils.id_card.jmrtd.BACKeySpec
import nashid.verify.sdk.utils.id_card.jmrtd.PassportService.DEFAULT_MAX_BLOCKSIZE
import nashid.verify.sdk.utils.id_card.omn.OmanCardDG2File
import nashid.verify.sdk.utils.id_card.omn.OmanCardService
import nashid.verify.sdk.utils.id_card.omn.OmanCardService.NORMAL_MAX_TRANCEIVE_LENGTH
import nashid.verify.sdk.viewmodel.NfcLiveData
import nashid.verify.sdkNew.R
import net.sf.scuba.data.Gender
import net.sf.scuba.smartcards.CardService
import net.sf.scuba.smartcards.CardServiceException
import org.jmrtd.CardServiceProtocolException
import org.jmrtd.lds.icao.MRZInfo.createTD3MRZInfo

class NfcRepository(
    private val nfcLiveData: NfcLiveData,
    private val context: Context,
) {
    private var eDocument = EDocument()
    private var disposable = CompositeDisposable()

    fun readPassportNfc(tagFromIntent: Tag?) {
        val trustStore = MRTDTrustStore()
        val mrzInfo =
            createTD3MRZInfo(
                "P",
                "ESP",
                "DUMMY",
                "DUMMY",
                nfcLiveData.passportNumber.value,
                "ESP",
                nfcLiveData.dateOfBirth.value,
                Gender.MALE,
                nfcLiveData.dateOfExpiration.value,
                "DUMMY",
            )
        val nfcDocumentTag = NFCDocumentTag()
        val disposable1 =
            nfcDocumentTag.handleTag(
                context,
                tagFromIntent!!,
                mrzInfo,
                trustStore,
                object : NFCDocumentTag.PassportCallback {
                    override fun onProgresUpdate(progress: Int?) {
                        nfcLiveData.setMrtPercentage(progress!!)
                    }

                    override fun onPassportReadStart() {}

                    override fun onPassportReadFinish() {}

                    override fun onPassportRead(passport: Passport?) {
                        var docType = DocumentType.OTHER
                        val personDetails = PersonDetails()
                        val additionalPersonDetails = AdditionalPersonDetails()
                        val additionalDGFiles = AdditionalDGFiles()
                        personDetails.name =
                            passport!!
                                .personDetails!!
                                .secondaryIdentifier!!
                                .replace("<", " ")
                                .trim { it <= ' ' }
                        personDetails.surname =
                            passport.personDetails!!
                                .primaryIdentifier!!
                                .replace("<", " ")
                                .trim { it <= ' ' }
                        personDetails.personalNumber = passport.personDetails!!.optionalData1
                        personDetails.gender = passport.personDetails!!.gender.toString()
                        personDetails.birthDate =
                            DateUtil.convertFromMrzDate(
                                passport.personDetails!!.dateOfBirth,
                            )
                        personDetails.expiryDate =
                            DateUtil.convertFromMrzDate(
                                passport.personDetails!!.dateOfExpiry,
                            )
                        personDetails.serialNumber = passport.personDetails!!.documentNumber
                        personDetails.nationality = passport.personDetails!!.nationality
                        personDetails.issuerAuthority = passport.personDetails!!.issuingState
                        personDetails.isDigitalSigVerification =
                            passport.verificationStatus!!.ca === VerificationStatus.Verdict.SUCCEEDED
                        if ("I" == mrzInfo.documentCode) {
                            docType = DocumentType.OMAN_ID
                        } else if ("P" == mrzInfo.documentCode) {
                            docType = DocumentType.Passport
                        }
                        personDetails.faceImage = passport.face
                        personDetails.signature = passport.signature
                        if (passport.additionalPersonDetails != null) {
                            additionalPersonDetails.custodyInformation =
                                passport.additionalPersonDetails!!.custodyInformation
                            additionalPersonDetails.nameOfHolder =
                                passport.additionalPersonDetails!!.nameOfHolder!!.replace("null ", "")
                            additionalPersonDetails.fullDateOfBirth =
                                DateUtil.convertFromMrzDateDG12(
                                    passport.additionalPersonDetails!!.fullDateOfBirth,
                                )
                            additionalPersonDetails.otherNames =
                                passport.additionalPersonDetails!!.otherNames
                            additionalPersonDetails.otherValidTDNumbers =
                                passport.additionalPersonDetails!!.otherValidTDNumbers
                            additionalPersonDetails.permanentAddress =
                                passport.additionalPersonDetails!!.permanentAddress
                            additionalPersonDetails.personalNumber =
                                passport.additionalPersonDetails!!.personalNumber
                            additionalPersonDetails.personalSummary =
                                passport.additionalPersonDetails!!.personalSummary
                            additionalPersonDetails.placeOfBirth =
                                passport.additionalPersonDetails!!.placeOfBirth
                            additionalPersonDetails.profession =
                                passport.additionalPersonDetails!!.profession
                            additionalPersonDetails.proofOfCitizenship =
                                passport.additionalPersonDetails!!.proofOfCitizenship
                            additionalPersonDetails.tag = passport.additionalPersonDetails!!.tag
                            additionalPersonDetails.tagPresenceList =
                                passport.additionalPersonDetails!!.tagPresenceList
                            additionalPersonDetails.telephone =
                                passport.additionalPersonDetails!!.telephone
                            additionalPersonDetails.title = passport.additionalPersonDetails!!.title
                            eDocument.additionalPersonDetails = additionalPersonDetails
                        } else {
                            personDetails.name =
                                passport.personDetails!!.primaryIdentifier + " " + passport.personDetails!!.secondaryIdentifier
                        }
                        if (passport.dg14File != null) {
                            additionalDGFiles.securityInfos =
                                passport.dg14File!!.securityInfos.toString()
                        }
                        if (passport.additionalDocumentDetails != null) {
                            additionalDGFiles.issueingAuthority =
                                passport.additionalDocumentDetails!!.issuingAuthority
                            additionalDGFiles.dateOfIssue =
                                DateUtil.convertFromMrzDateDG12(
                                    passport.additionalDocumentDetails!!.dateOfIssue,
                                )
                            additionalDGFiles.personalizationDeviceSerialNumber =
                                passport.additionalDocumentDetails!!.personalizationSystemSerialNumber
                            additionalDGFiles.personalizationTime =
                                passport.additionalDocumentDetails!!.dateAndTimeOfPersonalization
                            eDocument.additionalDGFiles = additionalDGFiles
                        }
                        eDocument.rsaPublicKey = passport.rasPublicKey
                        eDocument.ecdsaPublicKey = passport.ecdsaPublicKey
                        eDocument.docType = docType
                        eDocument.personDetails = personDetails
                        LivenessData.getInstance().seteDocument(eDocument)
                        nfcLiveData.setShowResult(true)
                    }

                    override fun onAccessDeniedException(exception: CardServiceProtocolException) {
                        nfcLiveData.setShowError("")
                    }

                    override fun onBACDeniedException(exception: CardServiceProtocolException) {
                        nfcLiveData.setShowError("")
                    }

                    override fun onPACEException(exception: CardServiceProtocolException) {
                        nfcLiveData.setShowError("")
                    }

                    override fun onCardException(exception: CardServiceException) {
                        nfcLiveData.setShowError("card")
                    }

                    override fun onGeneralException(exception: Exception?) {
                        nfcLiveData.setShowError("")
                    }
                },
            )
        disposable.add(disposable1)
    }

    fun readOmanIdNFC(
        isoDep: IsoDep,
        bacKey: BACKeySpec,
    ): ReadResult? =
        try {
            val cardService = CardService.getInstance(isoDep)
            cardService.open()

            val service =
                OmanCardService(
                    cardService,
                    NORMAL_MAX_TRANCEIVE_LENGTH,
                    DEFAULT_MAX_BLOCKSIZE,
                    false,
                    false,
                )
            service.open()
            service.sendSelectApplet(false)
            service.doBAC(bacKey)

            nfcLiveData.setMrtPercentage(5)

            val dgFile1 = service.readFile(OmanCardService.SFI_DG1.toShort())
            if (dgFile1 == null) {
                nfcLiveData.setShowError(context.resources.getString(R.string.error_dg1_is_null))
            }
            Utility.getInstance().dgFile1 = (dgFile1)
            nfcLiveData.setMrtPercentage(20)

            val dgFile2 = service.readFile(OmanCardService.SFI_DG2.toShort())
            if (dgFile2 == null) {
                nfcLiveData.setShowError(context.resources.getString(R.string.error_dg2_is_null))
            }

            Utility.getInstance().dgFile2 = (dgFile2)
            val dgFile2Obj = OmanCardDG2File(Utility.getInstance().dgFile2)

            val decodedString =
                Base64.decode(dgFile2Obj.getTagValue(OmanCardDG2File.TAG_PHOTO), Base64.DEFAULT)
            LivenessData
                .getInstance()
                .setNfcBitmap(BitmapFactory.decodeByteArray(decodedString, 0, decodedString.size))
            DocumentImages.instance.nfcPhoto =
                (BitmapFactory.decodeByteArray(decodedString, 0, decodedString.size))
            nfcLiveData.setMrtPercentage(35)

            val dgFile4 = service.readFile(OmanCardService.SFI_DG4.toShort())
            if (dgFile4 == null) {
                nfcLiveData.setShowError(context.resources.getString(R.string.error_dg4_is_null))
            }
            Utility.getInstance().dgFile4 = (dgFile4)
            nfcLiveData.setMrtPercentage(50)
            val dgFile6 = service.readFile(OmanCardService.SFI_DG6.toShort())
            if (dgFile6 == null) {
                nfcLiveData.setShowError(context.resources.getString(R.string.error_dg6_is_null))
            }
            Utility.getInstance().dgFile6 = (dgFile6)
            nfcLiveData.setMrtPercentage(65)

            try {
                val dgFile10 = service.readFile(OmanCardService.SFI_DG10.toShort())
                if (dgFile10 == null) {
                    nfcLiveData.setShowError(context.resources.getString(R.string.error_dg10_is_null))
                }
                Utility.getInstance().dgFile10 = (dgFile10)
            } catch (e: Exception) {
                e.printStackTrace()
            }
            nfcLiveData.setMrtPercentage(75)

            try {
                val dgFile11 = service.readFile(OmanCardService.SFI_DG11.toShort())
                if (dgFile11 == null) {
                    nfcLiveData.setShowError(context.resources.getString(R.string.error_dg11_is_null))
                }
                Utility.getInstance().dgFile11 = (dgFile11)
            } catch (e: Exception) {
                e.printStackTrace()
            }
            nfcLiveData.setMrtPercentage(85)

            try {
                val dgFile13 = service.readFile(OmanCardService.SFI_DG13.toShort())
                if (dgFile13 == null) {
                    nfcLiveData.setShowError(context.resources.getString(R.string.error_dg13_is_null))
                }
                Utility.getInstance().dgFile13 = (dgFile13)
            } catch (e: Exception) {
                e.printStackTrace()
            }

            ReadResult(100)
        } catch (e: Exception) {
            e.printStackTrace()
            nfcLiveData.setShowError("An error occurred: ${e.message}")
            null
        }

    fun fetchEDocument(): EDocument = eDocument

    fun fetchDisposable(): CompositeDisposable = disposable

    data class ReadResult(
        val percentage: Int,
        val error: String? = null,
    )
}
