package nashid.verify.sdk.model

import com.google.gson.annotations.SerializedName

data class SubmitVerification(
    @SerializedName("metadata")
    val verificationMetadata: SubmitVerificationMetadata,
    @SerializedName("type")
    val type: Int,
    @SerializedName("data")
    val data: SubmitVerificationMainData,
    @SerializedName("artifacts")
    val artifacts: SubmitVerificationArtifacts,
    @SerializedName("status")
    val status: Int,
)

data class SubmitVerificationMetadata(
    @SerializedName("timestamp")
    val timestamp: String,
    @SerializedName("location")
    val location: SubmitVerificationLocation,
    @SerializedName("device_ipv4")
    val deviceIp4: String,
    @SerializedName("device_ipv6")
    val deviceIp6: String,
    @SerializedName("system_name")
    val systemName: String,
    @SerializedName("system_version")
    val systemVersion: String,
    @SerializedName("app_version")
    val appVersion: String,
    @SerializedName("device_identifier")
    val deviceIdentifier: String,
    @SerializedName("device_type")
    val deviceType: String,
    @SerializedName("gender")
    val gender: String? = null,
    @SerializedName("extra_data")
    val extraData: ExtraData? = null,
)

data class SubmitVerificationLocation(
    @SerializedName("longitude")
    val longitude: Double,
    @SerializedName("latitude")
    val latitude: Double,
)

data class SubmitVerificationMainData(
    @SerializedName("scan")
    val scan: SubmitVerificationScan?,
    @SerializedName("NFC")
    val nfc: SubmitVerificationNFC?,
    @SerializedName("liveness")
    val liveness: SubmitVerificationLiveness?,
)

data class SubmitVerificationScan(
    @SerializedName("mrz_text")
    val mrzText: String,
    @SerializedName("document_no")
    val documentNo: String,
    @SerializedName("document_type")
    val documentType: String,
    @SerializedName("expiry_date")
    val expiryDate: String,
    @SerializedName("date_of_birth")
    val dateOfBirth: String,
    @SerializedName("full_name")
    val fullName: String,
    @SerializedName("nationality")
    val nationality: String,
    @SerializedName("country")
    val country: String,
    @SerializedName("gender")
    val gender: String,
)

data class SubmitVerificationNFC(
    @SerializedName("full_name_english")
    val fullNameEnglish: String,
    @SerializedName("nationality_english")
    val nationalityEnglish: String,
    @SerializedName("gender_english")
    val genderEnglish: String,
    @SerializedName("gender_arabic")
    val genderArabic: String,
    @SerializedName("company_name_english")
    val companyNameEnglish: String,
    @SerializedName("permit_type")
    val permitType: String,
    @SerializedName("country_of_birth_arabic")
    val countryOfBirthArabic: String,
    @SerializedName("place_of_issue_arabic")
    val placeOfIssueArabic: String,
    @SerializedName("identity_number")
    val identityNumber: String,
    @SerializedName("place_of_issue_english")
    val placeOfIssueEnglish: String,
    @SerializedName("expiry_date")
    val expiryDate: String,
    @SerializedName("visa_number")
    val visaNumber: String,
    @SerializedName("issue_date")
    val issueDate: String,
    @SerializedName("full_name_arabic")
    val fullNameArabic: String,
    @SerializedName("company_name_arabic")
    val companyNameArabic: String,
    @SerializedName("country_of_birth_english")
    val countryOfBirthEnglish: String,
    @SerializedName("nationality_arabic")
    val nationalityArabic: String,
    @SerializedName("company_address_arabic")
    val companyAddressArabic: String,
    @SerializedName("permit_number")
    val permitNumber: String,
    @SerializedName("date_of_birth")
    val dateOfBirth: String,
    @SerializedName("use_by_date")
    val useByDate: String,
    @SerializedName("document_type")
    val passportDocType: String = "",
    @SerializedName("nationality")
    val passportNationality: String = "",
    @SerializedName("document_number")
    val passDocNumber: String = "",
    @SerializedName("issuing_country")
    val passportIssuingCountry: String = "",
    @SerializedName("passport_date_of_birth")
    val passportDateOfBirth: String = "",
    @SerializedName("gender")
    val passportGender: String = "",
    @SerializedName("document_expiry_date")
    val passportDocExpiryDate: String = "",
    @SerializedName("name")
    val passportName: String = "",
    @SerializedName("place_of_birth")
    val passportPlaceOfBirth: String = "",
    @SerializedName("address")
    val passportAddress: String = "",
    @SerializedName("profession")
    val passportProfession: String = "",
    @SerializedName("title")
    val passportTitle: String = "",
    @SerializedName("personal_summary")
    val passportPersonalSummary: String = "",
    @SerializedName("td_number")
    val passportTDNumber: String = "",
    @SerializedName("phone_number")
    val passportPhoneNumber: String = "",
    @SerializedName("name_of_holder")
    val passportNameOfHolder: String = "",
    @SerializedName("issuing_authority")
    val passportIssuingAuthority: String = "",
)

data class SubmitVerificationLiveness(
    @SerializedName("passive_liveness_confirmed")
    val passiveLivenessConfirmed: Boolean,
    @SerializedName("active_liveness_confirmed")
    val activeLivenessConfirmed: Boolean,
    @SerializedName("score")
    val score: String,
)

data class SubmitVerificationArtifacts(
    @SerializedName("back_side_image")
    val backSideImage: String,
    @SerializedName("front_side_image")
    val frontSideImage: String,
    @SerializedName("ocr_face_image")
    val ocrFaceImage: String,
    @SerializedName("nfc_face_image")
    val nfcFaceImage: String,
    @SerializedName("liveness_image")
    val livenessImage: String,
    @SerializedName("livness_image_without_bg")
    val livenessImageWithoutBg: String,
)
