package nashid.verify.sdk.viewmodel

import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import nashid.verify.sdk.utils.OtherConstant
import nashid.verify.sdk.utils.helpers.Utility
import java.lang.Boolean.FALSE

class NfcLiveData {
    private val _selectedDoc = MutableLiveData("")
    val selectedDoc: LiveData<String> get() = _selectedDoc

    private val _passportNumber = MutableLiveData("")
    val passportNumber: LiveData<String> get() = _passportNumber

    private val _dateOfBirth = MutableLiveData("")
    val dateOfBirth: LiveData<String> get() = _dateOfBirth

    private val _dateOfExpiration = MutableLiveData("")
    val dateOfExpiration: LiveData<String> get() = _dateOfExpiration

    private val _skipNFC = MutableLiveData(false)
    val skipNFC: LiveData<Boolean> get() = _skipNFC

    private val _maxTry = MutableLiveData(0)
    val maxTry: LiveData<Int> get() = _maxTry

    private val _isInternetAvailable = MutableLiveData(false)
    val isInternetAvailable: LiveData<Boolean> get() = _isInternetAvailable

    private val _isApiCalled = MutableLiveData(false)
    val isApiCalled: LiveData<Boolean> get() = _isApiCalled

    private val _isNfcEnabled = MutableLiveData(false)
    val isNfcEnabled: LiveData<Boolean> get() = _isNfcEnabled

    private val showDialogEvent = MutableLiveData<Boolean>()

    private val _showError = MutableLiveData<String?>()
    val showError: LiveData<String?> get() = _showError

    private val _mrtdPercentage = MutableLiveData(0)

    private val _showResult = MutableLiveData(false)
    val showResult: LiveData<Boolean> get() = _showResult
    val mrtdPercentage: LiveData<Int> get() = _mrtdPercentage

    init {
        OtherConstant.getInstance().skipNFC = false
        _passportNumber.value = Utility.getInstance().passportNumber
        _dateOfBirth.value = Utility.getInstance().dateOfBirth
        _dateOfExpiration.value = Utility.getInstance().expiryDate
    }

    fun updateData() {
        OtherConstant.getInstance().skipNFC = false
        _passportNumber.value = Utility.getInstance().passportNumber
        _dateOfBirth.value = Utility.getInstance().dateOfBirth
        _dateOfExpiration.value = Utility.getInstance().expiryDate
        _showResult.value = FALSE
        _maxTry.value = 0
        _showError.value = null
    }

    // Setters
    fun setSelectedDoc(doc: String) {
        _selectedDoc.value = doc
    }

    fun setDateOfBirth(doc: String) {
        _dateOfBirth.value = doc
    }

    fun setExpiryDate(expiryDate: String) {
        _dateOfExpiration.value = expiryDate
    }

    fun setDocumentNumber(docNo: String) {
        _passportNumber.value = docNo
    }

    fun setSkipNFC(skipNFC: Boolean) {
        _skipNFC.value = skipNFC
    }

    fun setInternetConnection(isAvailable: Boolean) {
        _isInternetAvailable.value = isAvailable
    }

    fun setIsApiCalled(isApiCalled: Boolean) {
        _isApiCalled.value = isApiCalled
    }

    fun setMaxTry(maxTry: Int) {
        _maxTry.value = maxTry
    }

    fun setIsNfcEnabled(isEnabled: Boolean) {
        _isNfcEnabled.value = isEnabled
    }

    fun setShowDialog(showDialog: Boolean) {
        showDialogEvent.value = showDialog
    }

    fun setMrtPercentage(percentage: Int) {
        _mrtdPercentage.postValue(percentage) // Use postValue for background thread
    }

    fun setShowResult(show: Boolean) {
        _showResult.postValue(show) // Use postValue for background thread
    }

    fun setShowError(error: String?) {
        _showError.postValue(error) // Use postValue for background thread
    }
}
