package nashid.verify.sdk.viewmodel

import android.graphics.Bitmap
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData

class SkipNfcLiveNessLiveData {
    private val isLiveness = MutableLiveData(false)
    private val livenessBitmap = MutableLiveData<Bitmap?>(null)
    private val scanBitmap = MutableLiveData<Bitmap?>(null)
    private val isApiCalled = MutableLiveData(false)
    private val finishActivity = MutableLiveData(false)
    private val hideProgressBar = MutableLiveData(false)
    private val isInternetAvailable = MutableLiveData(false)
    private val callLocationData = MutableLiveData(false)
    private val selectedDoc = MutableLiveData("")
    private val faceMatchApiFail = MutableLiveData("")

    fun setInternetConnection(isAvailable: Boolean) {
        isInternetAvailable.value = isAvailable
    }

    fun getHandleLocationData(): LiveData<Boolean> = callLocationData

    fun setHandleLocationData(isAvailable: Boolean) {
        callLocationData.value = isAvailable
    }

    fun getInternetConnection(): LiveData<Boolean> = isInternetAvailable

    fun getIsApiCalled(): LiveData<Boolean> = isApiCalled

    fun getFaceMatchApiFail(): LiveData<String> = faceMatchApiFail

    fun setFaceMatchApiFail(errorMessage: String) {
        faceMatchApiFail.value = errorMessage
    }

    fun setIsApiCalled(apiCalled: Boolean) {
        isApiCalled.value = apiCalled
    }

    fun getLivenessBitmap(): LiveData<Bitmap?> = livenessBitmap

    fun setLivenessBitmap(bitmap: Bitmap?) {
        livenessBitmap.value = bitmap
    }

    fun getScanBitmap(): LiveData<Bitmap?> = scanBitmap

    fun setScanBitmap(bitmap: Bitmap?) {
        scanBitmap.value = bitmap
    }

    fun getFinishActivity(): LiveData<Boolean> = finishActivity

    fun requestFinishActivity() {
        finishActivity.value = true
    }

    fun getHideProgressBar(): LiveData<Boolean> = hideProgressBar

    fun hideProgressBar() {
        hideProgressBar.value = true
    }

    fun getSelectedDoc(): LiveData<String> = selectedDoc

    fun setSelectedDoc(doc: String) {
        selectedDoc.value = doc
    }

    fun getIsLiveness(): LiveData<Boolean> = isLiveness

    fun setIsLiveness(liveness: Boolean) {
        isLiveness.value = liveness
    }

    fun clear() {
        isLiveness.value = false
        livenessBitmap.value = null
        scanBitmap.value = null
        isApiCalled.value = false
        finishActivity.value = false
        hideProgressBar.value = false
        isInternetAvailable.value = false
        callLocationData.value = false
        selectedDoc.value = ""
        faceMatchApiFail.value = ""
    }
}
