package nashid.verify.sdk.model

enum class DocumentType(
    val displayName: String,
    val value: Int,
) {
    OMAN_ID("Oman ID", 1),
    INTERNATIONAL_PASSPORT("Passport", 2),
    EMIRATI_ID("Emirati ID", 3),
    SAUDI_ID("Saudi ID", 4),
    BAHRAINI_ID("Bahraini ID", 5),
    QATARI_ID("Qatari ID", 6),
    KUWAITI_ID("Kuwaiti ID", 7),
    OTHER("Other", 8),
    ;

    fun getDetails(): String = "Display Name: $displayName, Value: $value"
}
