package nashid.mv.liveness
import android.graphics.Rect
import androidx.databinding.BaseObservable
import androidx.databinding.Bindable
import nashid.mv.engine.FaceBoxes

internal class DetectionResults() : BaseObservable() {
    @get:Bindable
    var left: Int = 0
        set(value) {
            field = value
            notifyPropertyChanged(BRS.left)
        }

    @get:Bindable
    var top: Int = 0
        set(value) {
            field = value
            notifyPropertyChanged(BRS.top)
        }

    @get:Bindable
    var right: Int = 0
        set(value) {
            field = value
            notifyPropertyChanged(BRS.right)
        }

    @get:Bindable
    var bottom: Int = 0
        set(value) {
            field = value
            notifyPropertyChanged(BRS.bottom)
        }

    @get:Bindable
    var confidence: Float = 0.toFloat()
        set(value) {
            field = value
            notifyPropertyChanged(BRS.confidence)
        }

    var time: Long = 0

    var threshold: Float = 0F

    @get:Bindable
    var hasFace: Boolean = false
        set(value) {
            field = value
            notifyPropertyChanged(BRS.hasFace)
        }

    constructor(faceBoxes: FaceBoxes, time: Long, hasFace: Boolean) : this() {
        this.left = faceBoxes.left
        this.top = faceBoxes.top
        this.right = faceBoxes.right
        this.bottom = faceBoxes.bottom
        this.confidence = faceBoxes.confidence
        this.time = time
        this.hasFace = hasFace
    }

    fun updateLocation(rect: Rect): DetectionResults {
        this.left = rect.left
        this.top = rect.top
        this.right = rect.right
        this.bottom = rect.bottom

        return this
    }

    override fun toString(): String = "DetectionResult(left=$left, top=$top, right=$right, bottom=$bottom, confidence=$confidence, time=$time, threshold=$threshold, hasFace=$hasFace)"
}
