package nashid.verify.sdk.data.remote

import nashid.verify.sdk.model.AuthResponse
import nashid.verify.sdk.model.RefreshTokenResponse
import nashid.verify.sdk.model.ScanData
import nashid.verify.sdk.model.SubmitVerification
import nashid.verify.sdk.model.UploadFileResponse
import nashid.verify.sdk.model.VerificationResponse
import nashid.verify.sdk.request.AuthRequest
import nashid.verify.sdk.request.RefreshTokenRequest
import okhttp3.MultipartBody
import retrofit2.Response
import retrofit2.http.Body
import retrofit2.http.GET
import retrofit2.http.Header
import retrofit2.http.Multipart
import retrofit2.http.POST
import retrofit2.http.Part
import retrofit2.http.Path

interface ApiService {
    @POST("authenticate/")
    suspend fun authenticate(
        @Body auth: AuthRequest,
    ): Response<AuthResponse>

    @POST("token-refresh/")
    suspend fun tokenRefresh(
        @Body token: RefreshTokenRequest,
    ): Response<RefreshTokenResponse>

    @Multipart
    @POST("submit-an-artifact/")
    suspend fun uploadFile(
        @Header("Authorization") token: String,
        @Header("APP-KEY") appKey: String,
        @Part file: MultipartBody.Part,
    ): Response<UploadFileResponse>

    @POST("verification/")
    suspend fun submitVerification(
        @Header("Authorization") token: String,
        @Header("APP-KEY") appKey: String,
        @Body verification: SubmitVerification,
    ): Response<VerificationResponse>

    @GET("verification/{id}/")
    suspend fun getVerification(
        @Header("Authorization") token: String,
        @Header("APP-KEY") appKey: String,
        @Path("id") id: String,
    ): Response<ScanData>
}
