package nashid.verify.sdk.utils

import android.location.Location
import androidx.fragment.app.FragmentActivity
import nashid.verify.sdk.utils.helpers.LocationHelper
import nashid.verify.sdk.utils.helpers.PermissionHelper

internal object PermissionAndLocationHelper {
    interface ResultCallback {
        fun onResult(
            latitude: Double,
            longitude: Double,
            address: String,
        )
    }

    fun requestPermissionAndLocation(
        activity: FragmentActivity,
        callback: ResultCallback,
    ) {
        PermissionHelper.requestsPermissions(
            activity,
            object : PermissionHelper.PermissionCallback {
                override fun onResult(
                    allGranted: Boolean,
                    grantedList: List<String>,
                    deniedList: List<String>,
                ) {
                    if (allGranted) {
                        val locationHelper = LocationHelper(activity)
                        locationHelper.getLastLocation(
                            object : LocationHelper.LocationCallback {
                                override fun onLocationResult(
                                    location: Location,
                                    address: String,
                                ) {
                                    val latitude = location.latitude
                                    val longitude = location.longitude
                                    callback.onResult(latitude, longitude, address)
                                }
                            },
                        )
                    } else {
                        callback.onResult(0.0, 0.0, "")
                    }
                }
            },
        )
    }
}
