package nashid.verify.sdk.utils.helpers

import android.Manifest
import androidx.fragment.app.FragmentActivity
import com.permissionx.guolindev.PermissionX

internal object PermissionHelper {
    interface PermissionCallback {
        fun onResult(
            allGranted: Boolean,
            grantedList: List<String>,
            deniedList: List<String>,
        )
    }

    fun requestsPermissions(
        activity: FragmentActivity,
        callback: PermissionCallback,
    ) {
        PermissionX.init(activity)
            .permissions(Manifest.permission.CAMERA, Manifest.permission.ACCESS_FINE_LOCATION)
            .onExplainRequestReason { scope, deniedList ->
                scope.showRequestReasonDialog(
                    deniedList,
                    "Core fundamental are based on these permissions",
                    "OK",
                    "Cancel",
                )
            }
            .onForwardToSettings { scope, deniedList ->
                scope.showForwardToSettingsDialog(
                    deniedList,
                    "You need to allow necessary permissions in Settings manually",
                    "OK",
                    "Cancel",
                )
            }
            .request { allGranted, grantedList, deniedList ->
                callback.onResult(allGranted, grantedList, deniedList)
            }
    }
}
