package nashid.verify.sdk.utils.id_card.omn;

import net.sf.scuba.util.Hex;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class OmanCardDG13File {
    public static final Charset charset = StandardCharsets.UTF_16LE;
    public static final int TAG_SPONSOR_RELATIONSHIP = 0xAD2D;
    public static final int TAG_SPONSOR_NUMBER = 0x2D2E;
    public static final int TAG_SPONSOR_ISSUE_DATE = 0x4D2F;
    public static final int TAG_SPONSOR_EXPIRY_DATE = 0x4D30;

    String sponsorRelationship;
    String sponsorNumber;
    String sponsorIssueDate;
    String sponsorExpiryDate;

    public OmanCardDG13File(byte[] buffer) throws IOException {
        OmanCardDataInputStream omanCardDataInputStream =  new OmanCardDataInputStream(new ByteArrayInputStream(buffer));

        sponsorRelationship = new String(omanCardDataInputStream.getTagValue(TAG_SPONSOR_RELATIONSHIP),charset);
        sponsorNumber = Hex.toHexString(omanCardDataInputStream.getTagValue(TAG_SPONSOR_NUMBER));
        sponsorIssueDate = Hex.toHexString(omanCardDataInputStream.getTagValue(TAG_SPONSOR_ISSUE_DATE));
        sponsorExpiryDate = Hex.toHexString(omanCardDataInputStream.getTagValue(TAG_SPONSOR_EXPIRY_DATE));
    }

    public String getTagValue(int tag)
    {
        switch (tag){
            case TAG_SPONSOR_RELATIONSHIP: return sponsorRelationship;
            case TAG_SPONSOR_NUMBER: return sponsorNumber;
            case TAG_SPONSOR_ISSUE_DATE: return sponsorIssueDate;
            case TAG_SPONSOR_EXPIRY_DATE: return sponsorExpiryDate;
            default: break;
        }
        return null;
    }

    @Override
    public String toString() {
        return "OmanCardDG13File{" +
                ""+TAG_SPONSOR_RELATIONSHIP+"='" + sponsorRelationship + '\'' +
                ", "+TAG_SPONSOR_NUMBER+"='" + sponsorNumber + '\'' +
                ", "+TAG_SPONSOR_ISSUE_DATE+"='" + sponsorIssueDate + '\'' +
                ", "+TAG_SPONSOR_EXPIRY_DATE+"='" + sponsorExpiryDate + '\'' +
                '}';
    }
//    public String toString()
//    {
//        StringBuilder stringBuilder = new StringBuilder();
//        stringBuilder.append("DG13: ");
//        stringBuilder.append("{\"sponsorRelationship\": \"");stringBuilder.append(sponsorRelationship);
//        stringBuilder.append("\";\"sponsorNumber\": \"");stringBuilder.append(sponsorNumber);
//        stringBuilder.append("\";\"sponsorIssueDate\": \"");stringBuilder.append(sponsorIssueDate);
//        stringBuilder.append("\";\"sponsorExpiryDate\": \"");stringBuilder.append(sponsorExpiryDate);
//        stringBuilder.append("\"}");
//        return stringBuilder.toString();
//    }

    public String getSponsorRelationship() {
        return sponsorRelationship;
    }

    public void setSponsorRelationship(String sponsorRelationship) {
        this.sponsorRelationship = sponsorRelationship;
    }

    public String getSponsorNumber() {
        return sponsorNumber;
    }

    public void setSponsorNumber(String sponsorNumber) {
        this.sponsorNumber = sponsorNumber;
    }

    public String getSponsorIssueDate() {
        return sponsorIssueDate;
    }

    public void setSponsorIssueDate(String sponsorIssueDate) {
        this.sponsorIssueDate = sponsorIssueDate;
    }

    public String getSponsorExpiryDate() {
        return sponsorExpiryDate;
    }

    public void setSponsorExpiryDate(String sponsorExpiryDate) {
        this.sponsorExpiryDate = sponsorExpiryDate;
    }
}
