package nashid.verify.sdk.utils.helpers

import android.graphics.Bitmap
import com.google.mlkit.vision.common.InputImage
import com.google.mlkit.vision.face.FaceDetection
import com.google.mlkit.vision.face.FaceDetectorOptions

class FaceDetectionUtil {
    companion object {
        fun cropFaceFromIDCard(
            idCardBitmap: Bitmap,
            onComplete: (Bitmap?) -> Unit,
        ) {
            try {
                val options =
                    FaceDetectorOptions
                        .Builder()
                        .setPerformanceMode(FaceDetectorOptions.PERFORMANCE_MODE_ACCURATE)
                        .setLandmarkMode(FaceDetectorOptions.LANDMARK_MODE_NONE)
                        .setClassificationMode(FaceDetectorOptions.CLASSIFICATION_MODE_NONE)
                        .setMinFaceSize(0.1f)
                        .build()

                val detector = FaceDetection.getClient(options)
                val image = InputImage.fromBitmap(idCardBitmap, 0)
                detector
                    .process(image)
                    .addOnSuccessListener { faces ->
                        if (faces.isNotEmpty()) {
                            try {
                                val face = faces[0]
                                val bounds = face.boundingBox
                                val padding = 0.2f

                                if (bounds.width() <= 0 || bounds.height() <= 0) {
                                    onComplete(null)
                                    return@addOnSuccessListener
                                }

                                val newLeft = (bounds.left - bounds.width() * padding).toInt().coerceAtLeast(0)
                                val newTop = (bounds.top - bounds.height() * padding).toInt().coerceAtLeast(0)
                                val newRight = (bounds.right + bounds.width() * padding).toInt().coerceAtMost(idCardBitmap.width)
                                val newBottom = (bounds.bottom + bounds.height() * padding).toInt().coerceAtMost(idCardBitmap.height)

                                if (newRight <= newLeft || newBottom <= newTop) {
                                    onComplete(null)
                                    return@addOnSuccessListener
                                }

                                val croppedBitmap =
                                    Bitmap.createBitmap(
                                        idCardBitmap,
                                        newLeft,
                                        newTop,
                                        newRight - newLeft,
                                        newBottom - newTop,
                                    )
                                onComplete(croppedBitmap)
                            } catch (e: Exception) {
                                onComplete(null)
                            }
                        } else {
                            onComplete(null)
                        }
                    }.addOnFailureListener { e ->
                        onComplete(null)
                    }.addOnCompleteListener {
                        detector.close()
                    }
            } catch (e: Exception) {
                onComplete(null)
            }
        }
    }
}
