package nashid.verify.sdk.utils.id_card.omn;

import net.sf.scuba.util.Hex;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class OmanCardDG1File {
    public static final Charset charset = StandardCharsets.UTF_16LE;
    public static final int TAG_ID_NUMBER = 0x2100;
    public static final int TAG_ISSUE_DATE = 0x4101;
    public static final int TAG_EXPIRY_DATE = 0x4102;
    public static final int TAG_PLACE_OF_ISSUE_ENGLISH = 0xE104;
    public static final int TAG_PLACE_OF_ISSUE_ARABIC = 0xA103;

    String idNumber;
    String issueDate;
    String expiryDate;
    String placeOfIssueEnglish;
    String placeOfIssueArabic;

    @Override
    public String toString() {
        return "OmanCardDG1File{" +
                TAG_ID_NUMBER+"=" + idNumber + '\'' +
                ", "+TAG_ISSUE_DATE+"='" + issueDate + '\'' +
                ", "+TAG_EXPIRY_DATE+"='" + expiryDate + '\'' +
                ", "+TAG_PLACE_OF_ISSUE_ENGLISH+"='" + placeOfIssueEnglish + '\'' +
                ", "+TAG_PLACE_OF_ISSUE_ARABIC+"='" + placeOfIssueArabic + '\'' +
                '}';
    }

    public OmanCardDG1File(byte[] buffer) throws IOException {
        OmanCardDataInputStream omanCardDataInputStream =  new OmanCardDataInputStream(new ByteArrayInputStream(buffer));

        idNumber = Hex.toHexString(omanCardDataInputStream.getTagValue(TAG_ID_NUMBER));
        issueDate = Hex.toHexString(omanCardDataInputStream.getTagValue(TAG_ISSUE_DATE));
        expiryDate = Hex.toHexString(omanCardDataInputStream.getTagValue(TAG_EXPIRY_DATE));
        placeOfIssueArabic = new String(omanCardDataInputStream.getTagValue(TAG_PLACE_OF_ISSUE_ARABIC),charset);
        placeOfIssueEnglish = new String(omanCardDataInputStream.getTagValue(TAG_PLACE_OF_ISSUE_ENGLISH),charset);
    }

    public String getTagValue(int tag)
    {
        switch (tag){
            case TAG_ID_NUMBER: return idNumber;
            case TAG_ISSUE_DATE: return issueDate;
            case TAG_EXPIRY_DATE: return expiryDate;
            case TAG_PLACE_OF_ISSUE_ENGLISH: return placeOfIssueEnglish;
            case TAG_PLACE_OF_ISSUE_ARABIC: return  placeOfIssueArabic;
            default: break;
        }
        return null;
    }
  /*  public String toString()
    {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DG1: ");
        stringBuilder.append("{\"idNumber\": \"");stringBuilder.append(idNumber);
        stringBuilder.append("\";\"issueDate\": \"");stringBuilder.append(issueDate);
        stringBuilder.append("\";\"expiryDate\": \"");stringBuilder.append(expiryDate);
        stringBuilder.append("\";\"placeOfIssueArabic\": \"");stringBuilder.append(placeOfIssueArabic);
        stringBuilder.append("\";\"placeOfIssueEnglish\": \"");stringBuilder.append(placeOfIssueEnglish);
        stringBuilder.append("\"}");
        return stringBuilder.toString();
    }*/

    public String getIdNumber() {
        return idNumber;
    }

    public void setIdNumber(String idNumber) {
        this.idNumber = idNumber;
    }

    public String getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(String issueDate) {
        this.issueDate = issueDate;
    }

    public String getExpiryDate() {
        return expiryDate;
    }

    public void setExpiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
    }

    public String getPlaceOfIssueEnglish() {
        return placeOfIssueEnglish;
    }

    public void setPlaceOfIssueEnglish(String placeOfIssueEnglish) {
        this.placeOfIssueEnglish = placeOfIssueEnglish;
    }

    public String getPlaceOfIssueArabic() {
        return placeOfIssueArabic;
    }

    public void setPlaceOfIssueArabic(String placeOfIssueArabic) {
        this.placeOfIssueArabic = placeOfIssueArabic;
    }
}
