package nashid.verify.sdk.utils.id_card.omn;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class OmanCardDataInputStream  {
    public final DataInputStream dataInputStream;

    public OmanCardDataInputStream(ByteArrayInputStream paramInputStream) {
        this.dataInputStream = new DataInputStream(paramInputStream);
    }

    public byte[] getTagValue(int tag) throws IOException {
        int i;
        while(true){
            byte[] tagId = new byte[2];
            i =dataInputStream.read(tagId);
            if (-1 == i ) break;
            byte[] tagSize = new byte[2];
            i =dataInputStream.read(tagSize);
            if (-1 == i ) break;
            byte[] tagVal = new byte[byteArrayToInt(tagSize, 2)];
            dataInputStream.readFully(tagVal);
            if (tag == byteArrayToInt(tagId,2)) return tagVal;
        }
        return null;
    }

    public static int byteArrayToInt(byte[] param1ArrayOfbyte, int param1Int) {
        byte b = 0;
        if (param1Int > 4)
            return 0;
        int i = 0;
        while (b < param1Int) {
            i = i << 8 | param1ArrayOfbyte[b] & 0xFF;
            b++;
        }
        return i;
    }

}
