package nashid.verify.sdk.utils.helpers

import android.app.Activity
import android.content.Context
import android.os.Build
import android.view.View
import android.view.WindowInsetsController
import android.view.WindowManager
import android.widget.LinearLayout

class TextSizeConverter(
    private val context: Context,
) {
    private val scale: Float
        get() {
            val density = context.resources.displayMetrics.density
            val fontScale = context.resources.configuration.fontScale
            return density * fontScale
        }
    private val densityScale: Float
        get() = context.resources.displayMetrics.density // Used for dp-to-pixel conversions

    fun changeStatusBarColor(activity: Activity) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            val window = activity.window
            window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS)
            window.statusBarColor = activity.resources.getColor(android.R.color.white, null)
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R) {
                window.insetsController?.apply {
                    setSystemBarsAppearance(
                        WindowInsetsController.APPEARANCE_LIGHT_STATUS_BARS,
                        WindowInsetsController.APPEARANCE_LIGHT_STATUS_BARS,
                    )
                }
            } else {
                val decorView = activity.window.decorView
                decorView.systemUiVisibility = decorView.systemUiVisibility or View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR
            }
        }
    }

    // Convert DP to pixels for width
    fun getWidth(dp: Int): Int = (dp * densityScale + 0.5f).toInt()

    // Convert DP to pixels for height
    fun getHeight(dp: Int): Int = (dp * densityScale + 0.5f).toInt()

    // Convert DP to pixels for padding or margin
    fun getPaddingOrMarginValue(dp: Int): Int = (dp * densityScale + 0.5f).toInt()

    // Convert DP to pixels for corner radius
    fun calculateRadius(dp: Int): Int = (dp * densityScale + 0.5f).toInt()

    fun getLinearLayoutParam(): LinearLayout.LayoutParams =
        LinearLayout.LayoutParams(
            LinearLayout.LayoutParams.MATCH_PARENT,
            LinearLayout.LayoutParams.WRAP_CONTENT,
        )

    fun getMatchParentLinearLayoutParam(): LinearLayout.LayoutParams =
        LinearLayout.LayoutParams(
            LinearLayout.LayoutParams.MATCH_PARENT,
            LinearLayout.LayoutParams.MATCH_PARENT,
        )

    // Get scaled text size in pixels
    fun getTextSize(textSize: Int): Int = (textSize * scale + 0.5f).toInt()
}
