package nashid.mv.liveness

import android.content.res.AssetManager
import android.util.Log
import nashid.mv.engine.FaceBoxes
import nashid.mv.engine.FaceDetectors
import nashid.mv.engine.Lives

internal class EngineWrappers(
    private var assetManager: AssetManager,
) {
    private var faceDetectors: FaceDetectors = FaceDetectors()
    private var lives: Lives = Lives()

    fun init(): Boolean {
        var ret = faceDetectors.loadModel(assetManager)
        if (ret == 0) {
            ret = lives.loadModel(assetManager)
            return ret == 0
        }

        return false
    }

    fun destroy() {
        faceDetectors.destroy()
        lives.destroy()
    }

    fun detect(
        yuv: ByteArray,
        width: Int,
        height: Int,
        orientation: Int,
    ): DetectionResults {
        val boxes = detectFace(yuv, width, height, orientation)
        Log.d("TAG", "detectAndCropFace:box " + boxes)
        if (boxes.isNotEmpty()) {
            val begin = System.currentTimeMillis()
            val box =
                boxes[0].apply {
                    val c = detectLive(yuv, width, height, orientation, this)
                    confidence = c
                }
            val end = System.currentTimeMillis()
            return DetectionResults(box, end - begin, true)
        }

        return DetectionResults()
    }

    private fun detectFace(
        yuv: ByteArray,
        width: Int,
        height: Int,
        orientation: Int,
    ): List<FaceBoxes> = faceDetectors.detect(yuv, width, height, orientation)

    private fun detectLive(
        yuv: ByteArray,
        width: Int,
        height: Int,
        orientation: Int,
        faceBoxes: FaceBoxes,
    ): Float = lives.detect(yuv, width, height, orientation, faceBoxes)
}
