package nashid.verify.sdk

import nashid.verify.sdk.model.AuthCallback
import nashid.verify.sdk.model.DocumentType
import nashid.verify.sdk.model.DocumentVerification
import nashid.verify.sdk.model.ExtraData
import nashid.verify.sdk.model.ScanDocumentResult
import nashid.verify.sdk.utils.helpers.VerificationHandler

interface VerifySDKManager : VerificationHandler {
    fun initialize(
        sdkKey: String,
        sdkSecret: String,
        languageType: String = "en",
        extraData: ExtraData? = null,
        callback: AuthCallback,
    )

    /**
     * Set the SDK environment. Default is Release.
     * This will update the base URL and APP_KEY used by the SDK.
     */
    fun setEnvironment(env: Environment = Environment.Release)

    fun verify(
        documentType: DocumentType = DocumentType.OMAN_ID,
        callback: (ScanDocumentResult.ScanDocumentResponse) -> Unit,
    )

    fun getVerificationResult(
        verificationId: String,
        callback: (ScanDocumentResult.GetScanResultResponse) -> Unit,
    )

    override fun submitVerification(verification: DocumentVerification)

    companion object {
        @Volatile
        private var instance: VerifySDKManager? = null

        fun getInstance(): VerifySDKManager =
            instance ?: synchronized(this) {
                instance ?: VerifySDKManagerImpl().also { instance = it }
            }
    }
}
