package nashid.verify.sdk.ui

import android.content.Intent
import android.os.Bundle
import android.widget.Button
import androidx.appcompat.app.AppCompatActivity
import com.airbnb.lottie.LottieAnimationView
import nashid.verify.sdkNew.R

class LivenessInstructionActivity : AppCompatActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_liveness_instruction)

        val lottieView = findViewById<LottieAnimationView>(R.id.livenessAnimation)
        lottieView.setAnimation(R.raw.face_scan)
        lottieView.playAnimation()

        val btnNext = findViewById<Button>(R.id.btnNext)
        btnNext.setOnClickListener {
            val intent = Intent(this, SkipNfcLiveNessActivity::class.java)
            val docKey = getString(R.string.doc_key)
            val docType = intent.getStringExtra(docKey)
            if (docType != null) {
                intent.putExtra(docKey, docType)
            }
            startActivity(intent)
            finish()
        }
    }
}
