package nashid.verify.sdk.utils.helpers

import android.content.Context
import android.graphics.*
import android.view.SurfaceHolder
import android.widget.RelativeLayout
import androidx.core.content.ContextCompat
import nashid.verify.sdk.utils.Constants
import nashid.verify.sdkNew.R
import nashid.verify.sdkNew.databinding.ActivityCameraXliveAcitivityBinding

class FocusRectDrawer(
    private val context: Context,
    private val holder: SurfaceHolder,
    private val binding: ActivityCameraXliveAcitivityBinding,
    private val screenDivideValue: Double,
) {
    private var diameter: Int = 0
    private var left: Int = 0
    private var top: Int = 0
    private var right: Int = 0
    private var bottom: Int = 0
    private var boxWidth: Int = 0
    private var boxHeight: Int = 0
    private lateinit var canvas: Canvas

    fun drawFocusRect(color: Int) {
        try {
            val height = binding.previewView.height
            val width = binding.previewView.width
            diameter = width
            if (height < width) {
                diameter = height
            }
            val offset = (Constants.DRAW_SQUARE_OFFSET * diameter).toInt()
            diameter -= offset
            canvas = holder.lockCanvas()
            canvas.drawColor(
                ContextCompat.getColor(context, R.color.overlay_color),
                PorterDuff.Mode.ADD,
            )
            val paint = Paint()
            paint.style = Paint.Style.STROKE
            paint.color = color
            paint.strokeWidth = 3f
            left = width - diameter
            top = (height / screenDivideValue - diameter / 3).toInt()
            right = diameter
            bottom = (height / screenDivideValue + diameter / 3).toInt()
            boxHeight = bottom - top
            boxWidth = right - left
            val paint1 = Paint(Paint.DITHER_FLAG)
            paint1.style = Paint.Style.FILL
            paint1.color = Color.WHITE
            paint1.xfermode = PorterDuffXfermode(PorterDuff.Mode.CLEAR)
            val paint2 = Paint()
            paint2.style = Paint.Style.STROKE
            paint2.color = Color.WHITE
            paint2.strokeWidth = 4f
            val corner = 26
            val cornerSpace = 18
            paint.strokeJoin = Paint.Join.ROUND
            createCornersPath(
                left - cornerSpace,
                top - cornerSpace,
                right + cornerSpace,
                bottom + cornerSpace,
                paint2,
            )
            canvas.drawRoundRect(
                RectF(
                    left.toFloat(),
                    top.toFloat(),
                    right.toFloat(),
                    bottom.toFloat(),
                ),
                corner.toFloat(),
                corner.toFloat(),
                paint1,
            )
            canvas.drawRoundRect(
                RectF(
                    left.toFloat(),
                    top.toFloat(),
                    right.toFloat(),
                    bottom.toFloat(),
                ),
                corner.toFloat(),
                corner.toFloat(),
                paint,
            )
            holder.unlockCanvasAndPost(canvas)
            val params =
                RelativeLayout.LayoutParams(
                    boxWidth,
                    boxHeight,
                )
            params.topMargin = top
            params.addRule(RelativeLayout.CENTER_HORIZONTAL, RelativeLayout.TRUE)
            binding.scan.layoutParams = params
            binding.scan.invalidate()
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    private fun createCornersPath(
        left: Int,
        top: Int,
        right: Int,
        bottom: Int,
        paint: Paint,
    ) {
        val radius = 40f
        val lengthF = 80f
        canvas.drawLine(left + radius, top.toFloat(), left + lengthF, top.toFloat(), paint)
        canvas.drawLine(left.toFloat(), top + radius, left.toFloat(), top + lengthF, paint)
        val rectTL = RectF(left.toFloat(), top.toFloat(), left + radius * 2, top + radius * 2)
        canvas.drawArc(rectTL, 180f, 90f, false, paint)
        canvas.drawLine(right - radius, top.toFloat(), right - lengthF, top.toFloat(), paint)
        canvas.drawLine(right.toFloat(), top + radius, right.toFloat(), top + lengthF, paint)
        val rectTR = RectF(right - radius * 2, top.toFloat(), right.toFloat(), top + radius * 2)
        canvas.drawArc(rectTR, 270f, 90f, false, paint)
        canvas.drawLine(left + radius, bottom.toFloat(), left + lengthF, bottom.toFloat(), paint)
        canvas.drawLine(left.toFloat(), bottom - radius, left.toFloat(), bottom - lengthF, paint)
        val rectBL = RectF(left.toFloat(), bottom - radius * 2, left + radius * 2, bottom.toFloat())
        canvas.drawArc(rectBL, 90f, 90f, false, paint)
        canvas.drawLine(
            right - radius,
            bottom.toFloat(),
            right - lengthF,
            bottom.toFloat(),
            paint,
        )
        canvas.drawLine(
            right.toFloat(),
            bottom - radius,
            right.toFloat(),
            bottom - lengthF,
            paint,
        )
        val rectBR =
            RectF(right - radius * 2, bottom - radius * 2, right.toFloat(), bottom.toFloat())
        canvas.drawArc(rectBR, 0f, 90f, false, paint)
    }
}
