package nashid.verify.sdk.utils.helpers

import android.graphics.Bitmap
import com.google.zxing.*
import com.google.zxing.common.HybridBinarizer

object ZXingBarcodeUtil {
    /**
     * Attempts to decode a 1D barcode from the given bitmap using ZXing.
     * Returns the decoded string if successful, or null if not found.
     */
    fun decodeBarcodeFromBitmap(bitmap: Bitmap): String? {
        val intArray = IntArray(bitmap.width * bitmap.height)
        bitmap.getPixels(intArray, 0, bitmap.width, 0, 0, bitmap.width, bitmap.height)
        val source = RGBLuminanceSource(bitmap.width, bitmap.height, intArray)
        val binaryBitmap = BinaryBitmap(HybridBinarizer(source))

        val hints =
            mapOf(
                DecodeHintType.POSSIBLE_FORMATS to
                    listOf(
                        BarcodeFormat.CODE_128,
                        BarcodeFormat.CODE_39,
                        BarcodeFormat.CODE_93,
                        BarcodeFormat.CODABAR,
                        BarcodeFormat.EAN_13,
                        BarcodeFormat.EAN_8,
                        BarcodeFormat.ITF,
                        BarcodeFormat.UPC_A,
                        BarcodeFormat.UPC_E,
                    ),
                DecodeHintType.TRY_HARDER to true,
            )

        return try {
            val result = MultiFormatReader().decode(binaryBitmap, hints)
            result.text
        } catch (e: Exception) {
            null
        }
    }
}
