package nashid.verify.sdk

import nashid.verify.sdk.model.AuthCallback
import nashid.verify.sdk.model.DocumentType
import nashid.verify.sdk.model.DocumentVerification
import nashid.verify.sdk.model.ExtraData
import nashid.verify.sdk.model.ScanDocumentResult
import nashid.verify.sdk.model.VerifySDKCallback
import nashid.verify.sdk.model.VerifySdkEnvironment
import nashid.verify.sdk.utils.helpers.VerificationHandler

interface VerifySDKManager : VerificationHandler {
    fun initialize(
        sdkKey: String,
        sdkSecret: String,
        languageType: String = "en",
        extraData: ExtraData? = null,
        callback: AuthCallback,
    )

    /**
     * Set the SDK environment. Default is Production.
     * This will update the base URL and APP_KEY used by the SDK.
     */
    fun setEnvironment(env: VerifySdkEnvironment = VerifySdkEnvironment.Production)

    /**
     * Set the callback listener to receive SDK exit events.
     * This allows clients to handle user cancellations and completion events.
     */
    fun setCallback(callback: VerifySDKCallback?)

    /**
     * Get the current callback listener.
     * This allows internal SDK components to trigger exit events.
     */
    fun getCallback(): VerifySDKCallback?

    fun verify(
        documentType: DocumentType = DocumentType.OMAN_ID,
        callback: (ScanDocumentResult.ScanDocumentResponse) -> Unit,
    )

    fun getVerificationResult(
        verificationId: String,
        callback: (ScanDocumentResult.GetScanResultResponse) -> Unit,
    )

    override fun submitVerification(verification: DocumentVerification)

    override fun failedArtifactsVerification(verification: DocumentVerification)

    companion object {
        @Volatile
        private var instance: VerifySDKManager? = null

        fun getInstance(): VerifySDKManager =
            instance ?: synchronized(this) {
                instance ?: VerifySDKManagerImpl().also { instance = it }
            }
    }
}
