package nashid.verify.sdk.model

import com.google.gson.annotations.SerializedName

data class ScanData(
    @SerializedName("data")
    val data: VerificationResultData?,
    @SerializedName("message")
    val message: String,
    @SerializedName("consolidated_message")
    val consolidatedMessage: String,
    @SerializedName("errorMessage")
    val errorMessage: String?,
)

data class VerificationResultData(
    @SerializedName("id")
    val id: String,
    @SerializedName("data")
    val verificationDetails: VerificationDetails,
    @SerializedName("metadata")
    val metaData: MetaDataModel,
    @SerializedName("artifacts")
    val artifacts: ArtifactsModel,
    @SerializedName("annotations")
    val annotation: AnnotationModel,
    @SerializedName("type")
    val type: VerificationTypeModel,
    @SerializedName("status")
    val status: VerificationStatusModel,
    @SerializedName("status_notes")
    val statusNotes: List<String>? = null,
)

data class VerificationDetails(
    @SerializedName("scan")
    val scan: ScanDataModel?,
    @SerializedName("liveness")
    val liveness: LivenessDataModel?,
    @SerializedName("NFC")
    val nfc: NFCDataModel?,
)

data class ScanDataModel(
    @SerializedName("gender")
    val gender: String,
    @SerializedName("country")
    val country: String,
    @SerializedName("mrz_text")
    val mrzText: String,
    @SerializedName("full_name")
    val fullName: String,
    @SerializedName("document_no")
    val documentNo: String,
    @SerializedName("expiry_date")
    val expiryDate: String,
    @SerializedName("nationality")
    val nationality: String,
    @SerializedName("date_of_birth")
    val dateOfBirth: String,
    @SerializedName("document_type")
    val documentType: String,
    @SerializedName("card_number")
    val cardNumber: String = "",
)

data class LivenessDataModel(
    @SerializedName("active_liveness_confirmed")
    val activeLivenessConfirmed: Boolean,
    @SerializedName("passive_liveness_confirmed")
    val passiveLivenessConfirmed: Boolean,
)

data class NFCDataModel(
    @SerializedName("name")
    val name: String,
    @SerializedName("title")
    val title: String,
    @SerializedName("gender")
    val gender: String,
    @SerializedName("address")
    val address: String,
    @SerializedName("phone_number")
    val telephone: String,
    @SerializedName("issue_date")
    val issueDate: String,
    @SerializedName("profession")
    val profession: String,
    @SerializedName("td_numbers")
    val tdNumbers: String,
    @SerializedName("custody_info")
    val custodyInfo: String,
    @SerializedName("expiry_date")
    val expiryDate: String,
    @SerializedName("permit_type")
    val permitType: String,
    @SerializedName("use_by_date")
    val useByDate: String,
    @SerializedName("visa_number")
    val visaNumber: String,
    @SerializedName("date_of_birth")
    val dateOfBirth: String,
    @SerializedName("document_type")
    val documentType: String,
    @SerializedName("id_card_number")
    val idCardNumber: String,
    @SerializedName("place_of_birth")
    val placeOfBirth: String,
    @SerializedName("rsa_public_key")
    val rsaPublicKey: String,
    @SerializedName("issuing_country")
    val issuingCountry: String,
    @SerializedName("passport_number")
    val passportNumber: String,
    @SerializedName("personal_number")
    val personalNumber: String,
    @SerializedName("gender_arabic")
    val genderArabic: String,
    @SerializedName("permit_number")
    val permitNumber: String,
    @SerializedName("gender_english")
    val genderEnglish: String,
    @SerializedName("identity_number")
    val identityNumber: String,
    @SerializedName("full_name_arabic")
    val fullNameArabic: String,
    @SerializedName("full_name_english")
    val fullNameEnglish: String,
    @SerializedName("nationality_arabic")
    val nationalityArabic: String,
    @SerializedName("company_name_arabic")
    val companyNameArabic: String,
    @SerializedName("nationality_english")
    val nationalityEnglish: String,
    @SerializedName("company_name_english")
    val companyNameEnglish: String,
    @SerializedName("place_of_issue_arabic")
    val placeOfIssueArabic: String,
    @SerializedName("company_address_arabic")
    val companyAddressArabic: String,
    @SerializedName("place_of_issue_english")
    val placeOfIssueEnglish: String,
    @SerializedName("country_of_birth_arabic")
    val countryOfBirthArabic: String,
    @SerializedName("country_of_birth_english")
    val countryOfBirthEnglish: String,
    @SerializedName("ecdsa_public_key")
    val ecdsaPublicKey: String,
    @SerializedName("personal_summary")
    val personalSummary: String,
    @SerializedName("issuing_authority")
    val issuingAuthority: String,
    @SerializedName("document_expiry_date")
    val passportExpiryDate: String,
    @SerializedName("proof_of_citizenship")
    val proofOfCitizenship: String,
    @SerializedName("security_information")
    val securityInformation: String,
    @SerializedName("active_authentication_passed")
    val activeAuthenticationPassed: String,
    @SerializedName("issuer_digital_signature_verification")
    val issuerDigitalSignatureVerification: String,
    @SerializedName("name_of_holder")
    val nameOfHolder: String,
    @SerializedName("document_number")
    val documentNumber: String,
    @SerializedName("nationality")
    val passportNationality: String,
)

data class ArtifactsModel(
    @SerializedName("ocr_face_image")
    val ocrFaceImage: String,
    @SerializedName("back_side_image")
    val backSideImage: String,
    @SerializedName("front_side_image")
    val frontSideImage: String,
    @SerializedName("active_liveness_image")
    val activeLivenessImage: String?,
    @SerializedName("passive_liveness_image")
    val passiveLiveNessImage: String?,
    @SerializedName("nfc_face_image")
    val nfcFaceImage: String,
)

data class AnnotationModel(
    @SerializedName("face_matching")
    val faceMatching: FaceMatching,
)

data class FaceMatching(
    @SerializedName("notes")
    val notes: String,
    @SerializedName("is_successful")
    val isSuccessful: Boolean,
    @SerializedName("matching_score")
    val matchingScore: Int,
    @SerializedName("threshold_used")
    val thresholdUsed: Int,
)

data class VerificationTypeModel(
    @SerializedName("value")
    val value: Int,
    @SerializedName("title")
    val title: String,
)

data class VerificationStatusModel(
    @SerializedName("value")
    val value: Int,
    @SerializedName("title")
    val title: String,
)
