package nashid.verify.sdk.ui.adapter

import android.content.Context
import android.util.TypedValue
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import nashid.verify.sdk.utils.SdkConfig
import nashid.verify.sdk.utils.helpers.TextSizeConverter
import nashid.verify.sdkNew.databinding.ItemNfcDetailBinding

class NFCDetailAdapter(
    private val context: Context,
    private val list: HashMap<String, String>,
) : RecyclerView.Adapter<NFCDetailAdapter.ViewHolder>() {
    private val keys = list.keys.toTypedArray()

    override fun onCreateViewHolder(
        parent: ViewGroup,
        viewType: Int,
    ): ViewHolder {
        val layoutInflater = LayoutInflater.from(parent.context)
        val binding = ItemNfcDetailBinding.inflate(layoutInflater, parent, false)
        return ViewHolder(binding, context)
    }

    override fun onBindViewHolder(
        holder: ViewHolder,
        position: Int,
    ) {
        holder.bind(keys[position], list[keys[position]] ?: "")
    }

    override fun getItemCount(): Int = list.size

    class ViewHolder(
        val binding: ItemNfcDetailBinding,
        context: Context,
    ) : RecyclerView.ViewHolder(binding.root) {
        private val textSizeConverter = TextSizeConverter(context)

        init {
            val textSizePx = textSizeConverter.getTextSize(14)
            binding.txtFieldName.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizePx.toFloat())
            binding.txtFieldValue.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizePx.toFloat())

            binding.txtFieldName.setTextColor(SdkConfig.sdkAppTheme.getHeaderColorInt())
            binding.txtFieldValue.setTextColor(SdkConfig.sdkAppTheme.getHeaderColorInt())

            val paddingDivider = textSizeConverter.getPaddingOrMarginValue(12)
            val paddingLayout = textSizeConverter.getPaddingOrMarginValue(24)

            binding.divider.setPadding(0, paddingDivider, 0, 0)
            binding.lytNfcMain.setPadding(0, paddingLayout, 0, 0)
        }

        fun bind(
            fieldName: String,
            fieldValue: String,
        ) {
            binding.txtFieldName.text = fieldName
            binding.txtFieldValue.text = fieldValue
        }
    }
}
