package nashid.verify.sdk.ui.theme

import android.graphics.Color
import androidx.compose.ui.graphics.Color as ComposeColor

// Extension function to convert a color string to Int
fun String.toColorInt(): Int =
    try {
        Color.parseColor(this)
    } catch (e: Exception) {
        Color.BLACK // Fallback to black if parsing fails
    }

data class AppTheme(
    val primaryColor: String,
    val secondaryColor: String,
    val backgroundColor: String,
    val headerColor: String,
) {
    fun getPrimaryColorInt(): Int = primaryColor.toColorInt()

    fun getSecondaryColorInt(): Int = secondaryColor.toColorInt()

    fun getBackgroundColorInt(): Int = backgroundColor.toColorInt()

    fun getHeaderColorInt(): Int = headerColor.toColorInt()

    // Methods to get Compose Colors
    fun getPrimaryColor(): ComposeColor = ComposeColor(getPrimaryColorInt())

    fun getSecondaryColor(): ComposeColor = ComposeColor(getSecondaryColorInt())

    fun getBackgroundColor(): ComposeColor = ComposeColor(getBackgroundColorInt())

    fun getHeaderColor(): ComposeColor = ComposeColor(getHeaderColorInt())
}
