package nashid.verify.sdk.utils.helpers

import android.annotation.SuppressLint
import android.app.Activity
import android.app.Dialog
import android.util.TypedValue
import android.view.View
import android.view.View.GONE
import android.widget.LinearLayout
import androidx.core.content.ContextCompat
import com.airbnb.lottie.LottieDrawable
import nashid.verify.sdk.model.IDCardNFCData
import nashid.verify.sdk.utils.Constants
import nashid.verify.sdk.utils.SdkConfig
import nashid.verify.sdk.viewmodel.NFCViewModel
import nashid.verify.sdk.viewmodel.ScanDocumentViewModel
import nashid.verify.sdkNew.R
import nashid.verify.sdkNew.databinding.ActivityWaitingForNfcBinding
import java.text.DateFormat
import java.text.SimpleDateFormat

class NfcLayoutAndTextSize(
    private val textSizeConverter: TextSizeConverter,
    private val binding: ActivityWaitingForNfcBinding,
    private val context: Activity,
    private val storage: Storage,
    private val viewModel: NFCViewModel,
    private val scanDocumentViewModel: ScanDocumentViewModel,
) {
    private var progressDialog: Dialog? = null
    private var errorDialog: Dialog? = null
    private val dateFormat = "yyyyMMdd"
    private lateinit var idCardNFCData: IDCardNFCData

    fun setLayoutAndTextSize() {
        textSizeConverter.changeStatusBarColor(context)
        binding.layoutHeader.imgBack.setImageResource(R.drawable.back)
        if (storage.getPreferredLocale().equals("ar", ignoreCase = true)) {
            binding.layoutHeader.imgBack.rotation = 180f
        }
        var layoutParams2 = binding.layoutHeader.imgBack.layoutParams
        layoutParams2.width = textSizeConverter.getWidth(24)
        layoutParams2.height = textSizeConverter.getHeight(24)
        binding.layoutHeader.imgBack.layoutParams = layoutParams2
        binding.layoutHeader.imgBack.setColorFilter(SdkConfig.sdkAppTheme.getPrimaryColorInt())
        var layoutParams = textSizeConverter.getLinearLayoutParam()
        layoutParams.setMargins(0, textSizeConverter.getPaddingOrMarginValue(4), 0, 0)
        binding.layoutHeader.lytHeaderMain.layoutParams = layoutParams
        binding.layoutHeader.txtHelp.text = context.getString(R.string.nfc_chip_rading)
        binding.layoutHeader.txtHelp.setTextColor(SdkConfig.sdkAppTheme.getHeaderColorInt())
        binding.layoutHeader.txtHelp.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(17).toFloat(),
        )
        var padding = textSizeConverter.getPaddingOrMarginValue(16)
        binding.layoutMainNfc.setPadding(padding, padding, padding, padding)
        binding.layoutMainNfc.setBackgroundColor(SdkConfig.sdkAppTheme.getBackgroundColorInt())
        layoutParams2 = binding.layoutStepMain.lytStep.layoutParams
        layoutParams2.width = LinearLayout.LayoutParams.MATCH_PARENT
        layoutParams2.height = textSizeConverter.getHeight(30)
        binding.layoutStepMain.lytStep.layoutParams = layoutParams2
        var marginLayoutParam =
            binding.layoutStepMain.lytStep.layoutParams as LinearLayout.LayoutParams
        marginLayoutParam.setMargins(0, textSizeConverter.getPaddingOrMarginValue(32), 0, 0)
        binding.layoutStepMain.lytStep.layoutParams = marginLayoutParam
        val stepIconSize = 22
        var stepLayoutParam = binding.layoutStepMain.imgBack1.layoutParams
        stepLayoutParam.width = textSizeConverter.getWidth(stepIconSize)
        stepLayoutParam.height = textSizeConverter.getHeight(stepIconSize)
        binding.layoutStepMain.imgBack1.layoutParams = stepLayoutParam
        stepLayoutParam = binding.layoutStepMain.imgBack2.layoutParams
        stepLayoutParam.width = textSizeConverter.getWidth(stepIconSize)
        stepLayoutParam.height = textSizeConverter.getHeight(stepIconSize)
        binding.layoutStepMain.imgBack2.layoutParams = stepLayoutParam
        stepLayoutParam = binding.layoutStepMain.imgBack3.layoutParams
        stepLayoutParam.width = textSizeConverter.getWidth(stepIconSize)
        stepLayoutParam.height = textSizeConverter.getHeight(stepIconSize)
        binding.layoutStepMain.imgBack3.layoutParams = stepLayoutParam
        stepLayoutParam = binding.layoutStepMain.viewStep1Divider.layoutParams
        stepLayoutParam.width = LinearLayout.LayoutParams.MATCH_PARENT
        stepLayoutParam.height = textSizeConverter.getHeight(2)
        binding.layoutStepMain.viewStep1Divider.layoutParams = stepLayoutParam
        binding.layoutStepMain.imgBack1.setImageResource(R.drawable.ic_circle)
        binding.layoutStepMain.imgForeground1.setImageResource(R.drawable.complete_step1)
        binding.layoutStepMain.imgBack2.setImageResource(R.drawable.scan_complete_step2)
        binding.layoutStepMain.imgBack3.imageTintList =
            ContextCompat.getColorStateList(context, R.color.dottedline_tint)

        binding.layoutStepMain.imgBack1.setColorFilter(SdkConfig.sdkAppTheme.getSecondaryColorInt())
        binding.layoutStepMain.imgBack2.setColorFilter(SdkConfig.sdkAppTheme.getPrimaryColorInt())
        binding.layoutStepMain.imgForeground3.visibility = GONE

        binding.layoutStepMain.viewStep1Divider.setBackgroundResource(R.drawable.gradient_straight_line)
        binding.layoutStepMain.viewStep2Divider.backgroundTintList =
            ContextCompat.getColorStateList(context, R.color.dottedline_tint)
        marginLayoutParam = binding.txtTapHold.layoutParams as LinearLayout.LayoutParams
        marginLayoutParam.setMargins(0, textSizeConverter.getPaddingOrMarginValue(24), 0, 0)
        binding.txtTapHold.layoutParams = marginLayoutParam
        binding.txtTapHold.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(14).toFloat(),
        )
        marginLayoutParam = binding.txtTapHold.layoutParams as LinearLayout.LayoutParams
        marginLayoutParam.setMargins(0, textSizeConverter.getPaddingOrMarginValue(24), 0, 0)
        binding.txtTapHold.layoutParams = marginLayoutParam
        binding.txtTapHold.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(14).toFloat(),
        )
        viewModel.callNfcStatus()
        layoutParams2 = binding.nfcDialogTurnon.imgScanFailure.layoutParams
        layoutParams2.width = textSizeConverter.getWidth(56)
        layoutParams2.height = textSizeConverter.getHeight(56)
        binding.nfcDialogTurnon.imgScanFailure.layoutParams = layoutParams2
        layoutParams2 = binding.nfcDialogTurnon.imgInfo1.layoutParams
        layoutParams2.width = textSizeConverter.getWidth(20)
        layoutParams2.height = textSizeConverter.getHeight(20)
        binding.nfcDialogTurnon.imgInfo1.layoutParams = layoutParams2
        layoutParams2 = binding.nfcDialogTurnon.imgNfcFailed.layoutParams
        layoutParams2.width = textSizeConverter.getWidth(145)
        layoutParams2.height = textSizeConverter.getHeight(145)
        binding.nfcDialogTurnon.imgNfcFailed.layoutParams = layoutParams2
        val layoutParams1 =
            binding.nfcDialogTurnon.imgNfcFailed.layoutParams as LinearLayout.LayoutParams
        layoutParams1.setMargins(
            0,
            textSizeConverter.getPaddingOrMarginValue(24),
            0,
            textSizeConverter.getPaddingOrMarginValue(18),
        )
        binding.nfcDialogTurnon.imgNfcFailed.layoutParams = layoutParams1
        layoutParams2 = binding.nfcDialogTurnon.imgInfo2.layoutParams
        layoutParams2.width = textSizeConverter.getWidth(20)
        layoutParams2.height = textSizeConverter.getHeight(20)
        binding.nfcDialogTurnon.imgInfo2.layoutParams = layoutParams2
        layoutParams =
            binding.nfcDialogTurnon.imgScanFailure.layoutParams as LinearLayout.LayoutParams
        layoutParams.setMargins(0, textSizeConverter.getPaddingOrMarginValue(8), 0, 0)
        binding.nfcDialogTurnon.imgScanFailure.layoutParams = layoutParams
        binding.nfcDialogTurnon.txtScanCompleted.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(20).toFloat(),
        )
        layoutParams =
            binding.nfcDialogTurnon.txtScanCompleted.layoutParams as LinearLayout.LayoutParams
        layoutParams.setMargins(0, textSizeConverter.getPaddingOrMarginValue(24), 0, 0)
        binding.nfcDialogTurnon.txtScanCompleted.layoutParams = layoutParams
        binding.nfcDialogTurnon.txtScanNotCompleteDesc1.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(16).toFloat(),
        )
        layoutParams =
            binding.nfcDialogTurnon.txtScanNotCompleteDesc1.layoutParams as LinearLayout.LayoutParams
        layoutParams.setMargins(
            textSizeConverter.getPaddingOrMarginValue(6),
            textSizeConverter.getPaddingOrMarginValue(16),
            0,
            0,
        )
        binding.nfcDialogTurnon.txtScanNotCompleteDesc1.layoutParams = layoutParams
        binding.nfcDialogTurnon.txtScanNotCompleteDesc2.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(16).toFloat(),
        )
        binding.nfcDialogTurnon.imgNfcFailed.playAnimation()
        binding.nfcDialogTurnon.imgNfcFailed.repeatCount = LottieDrawable.INFINITE
        binding.nfcDialogTurnon.imgNfcFailed.setAnimation(R.raw.nfc_read_failed)
        layoutParams =
            binding.nfcDialogTurnon.txtScanNotCompleteDesc2.layoutParams as LinearLayout.LayoutParams
        layoutParams.setMargins(
            textSizeConverter.getPaddingOrMarginValue(6),
            textSizeConverter.getPaddingOrMarginValue(16),
            0,
            0,
        )
        binding.nfcDialogTurnon.txtScanNotCompleteDesc2.layoutParams = layoutParams
        layoutParams = binding.nfcDialogTurnon.imgInfo1.layoutParams as LinearLayout.LayoutParams
        layoutParams.setMargins(0, textSizeConverter.getPaddingOrMarginValue(16), 0, 0)
        binding.nfcDialogTurnon.imgInfo1.layoutParams = layoutParams
        layoutParams = binding.nfcDialogTurnon.imgInfo2.layoutParams as LinearLayout.LayoutParams
        layoutParams.setMargins(0, textSizeConverter.getPaddingOrMarginValue(16), 0, 0)
        binding.nfcDialogTurnon.imgInfo2.layoutParams = layoutParams
        layoutParams = binding.nfcDialogTurnon.btnRetry.layoutParams as LinearLayout.LayoutParams
        layoutParams.setMargins(
            0,
            textSizeConverter.getPaddingOrMarginValue(24),
            0,
            textSizeConverter.getPaddingOrMarginValue(28),
        )
        binding.nfcDialogTurnon.btnRetry.setCardBackgroundColor(SdkConfig.sdkAppTheme.getPrimaryColorInt())
        binding.nfcDialogTurnon.txtBtnRetry.setTextColor(SdkConfig.sdkAppTheme.getBackgroundColorInt())
        binding.nfcDialogTurnon.btnRetry.layoutParams = layoutParams
        padding = textSizeConverter.getPaddingOrMarginValue(12)
        binding.nfcDialogTurnon.txtBtnRetry.setPadding(0, padding, 0, padding)
        binding.nfcDialogTurnon.btnRetry.radius = textSizeConverter.calculateRadius(8).toFloat()
        binding.nfcDialogTurnon.lyoutError1.visibility = View.GONE
        binding.nfcDialogTurnon.txtBtnRetry.text = context.getString(R.string.turn_on_nfc)
        binding.nfcDialogTurnon.txtBtnRetry.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(16).toFloat(),
        )
        binding.logo.setImageResource(R.drawable.logo)
        binding.backbutton.setImageResource(R.drawable.arowback)
        binding.imgBackcrdScan.setAnimation(R.raw.nfc)
        binding.imgBackcrdScan.playAnimation()
        binding.imgBackcrdScan.repeatCount = LottieDrawable.INFINITE
    }

    fun handleSkipNFC(skipNFC: Boolean) {
        var marginLayoutParam = binding.txtBottomDesc.layoutParams as LinearLayout.LayoutParams
        marginLayoutParam.setMargins(0, 0, 0, textSizeConverter.getPaddingOrMarginValue(100))
        binding.txtBottomDesc.layoutParams = marginLayoutParam
        binding.txtBottomDesc.setTextColor(SdkConfig.sdkAppTheme.getHeaderColorInt())
        binding.txtBottomDesc.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(16).toFloat(),
        )
        marginLayoutParam.setMargins(
            0,
            textSizeConverter.getPaddingOrMarginValue(28),
            0,
            textSizeConverter.getPaddingOrMarginValue(28),
        )
        var layoutParams = binding.btnStartReadNfc.layoutParams as LinearLayout.LayoutParams
        layoutParams.setMargins(
            0,
            0,
            0,
            textSizeConverter.getPaddingOrMarginValue(12),
        )
        binding.btnStartReadNfc.layoutParams = layoutParams
        binding.btnStartReadNfc.setCardBackgroundColor(SdkConfig.sdkAppTheme.getPrimaryColorInt())
        binding.btnStartReadNfc.radius = textSizeConverter.calculateRadius(8).toFloat()
        binding.txtBtnStartReadNfc.setTextColor(SdkConfig.sdkAppTheme.getBackgroundColorInt())
        val padding = textSizeConverter.getPaddingOrMarginValue(12)
        binding.txtBtnStartReadNfc.setPadding(0, padding, 0, padding)
    }

    private fun dismissDialog() {
        if (errorDialog != null) {
            errorDialog!!.dismiss()
        }
        if (progressDialog != null) {
            progressDialog!!.dismiss()
        }
    }

    @SuppressLint("SimpleDateFormat")
    private fun formattedFrosting(inputDate: String): String {
        try {
            val sdf: DateFormat = SimpleDateFormat(dateFormat)
            val date = sdf.parse(inputDate)
            return SimpleDateFormat(Constants.DATE_FORMAT).format(date!!)
        } catch (_: Exception) {
        }
        return inputDate
    }
}
