package nashid.verify.sdk.model

sealed class ScanDocumentResult {
    data class FileKeyResult(val fileKey: String, val artifactType: String) : ScanDocumentResult()

    data class ScanDocumentResponse(val result: Boolean, val message: String, val verificationId: String) : ScanDocumentResult()

    data class GetScanResultResponse(val result: Boolean, val message: String, val verificationResult: ScanData?) : ScanDocumentResult()

    data class Error(val message: String) : ScanDocumentResult()
}
