package nashid.verify.sdk.ui.theme

import android.content.Context
import android.graphics.Typeface
import androidx.compose.ui.text.font.Font
import androidx.compose.ui.text.font.FontFamily
import androidx.core.content.res.ResourcesCompat
import nashid.verify.sdk.utils.SdkConfig
import nashid.verify.sdkNew.R

object FontManager {
    fun getFont(
        context: Context,
        weight: FontWeight,
    ): Typeface {
        val fontFamily = SdkConfig.fontName.trim().lowercase()
//        val fontFamily="space grotesk"
        val normalizedFamily = fontFamily.trim().lowercase()

        val fontRes =
            when (normalizedFamily to weight) {
                "ping ar" to FontWeight.REGULAR -> R.font.regular
                "ping ar" to FontWeight.MEDIUM -> R.font.pingmedium
                "ping ar" to FontWeight.BOLD -> R.font.header_bold

                "inter" to FontWeight.REGULAR -> R.font.interregular
                "inter" to FontWeight.MEDIUM -> R.font.intermedium
                "inter" to FontWeight.BOLD -> R.font.interbold

                "lato" to FontWeight.REGULAR -> R.font.latoregular
                "lato" to FontWeight.MEDIUM -> R.font.latomedium
                "lato" to FontWeight.BOLD -> R.font.latobold

                "space grotesk" to FontWeight.REGULAR -> R.font.spacegroteskregular
                "space grotesk" to FontWeight.MEDIUM -> R.font.spacegroteskmedium
                "space grotesk" to FontWeight.BOLD -> R.font.spacegroteskbold

                "poppins" to FontWeight.REGULAR -> R.font.poppinsregular
                "poppins" to FontWeight.MEDIUM -> R.font.poppinsmedium
                "poppins" to FontWeight.BOLD -> R.font.poppinsbold

                "public sans" to FontWeight.REGULAR -> R.font.publicsansregular
                "public sans" to FontWeight.MEDIUM -> R.font.publicsansmedium
                "public sans" to FontWeight.BOLD -> R.font.publicsansbold

                else -> R.font.regular
            }

        return ResourcesCompat.getFont(context, fontRes)!!
    }

    fun getFontFamily(): FontFamily {
//        val fontFamily = SdkConfig.fontName.trim().lowercase()
        val fontFamily = "space grotesk"
        val normalizedFamily = fontFamily.trim().lowercase()

        return when (normalizedFamily) {
            "ping ar" ->
                FontFamily(
                    Font(R.font.regular, androidx.compose.ui.text.font.FontWeight.Normal),
                    Font(R.font.pingmedium, androidx.compose.ui.text.font.FontWeight.Medium),
                    Font(R.font.header_bold, androidx.compose.ui.text.font.FontWeight.Bold),
                )
            "inter" ->
                FontFamily(
                    Font(R.font.interregular, androidx.compose.ui.text.font.FontWeight.Normal),
                    Font(R.font.intermedium, androidx.compose.ui.text.font.FontWeight.Medium),
                    Font(R.font.interbold, androidx.compose.ui.text.font.FontWeight.Bold),
                )
            "lato" ->
                FontFamily(
                    Font(R.font.latoregular, androidx.compose.ui.text.font.FontWeight.Normal),
                    Font(R.font.latomedium, androidx.compose.ui.text.font.FontWeight.Medium),
                    Font(R.font.latobold, androidx.compose.ui.text.font.FontWeight.Bold),
                )
            "space grotesk" ->
                FontFamily(
                    Font(R.font.spacegroteskregular, androidx.compose.ui.text.font.FontWeight.Normal),
                    Font(R.font.spacegroteskmedium, androidx.compose.ui.text.font.FontWeight.Medium),
                    Font(R.font.spacegroteskbold, androidx.compose.ui.text.font.FontWeight.Bold),
                )
            "public sans" ->
                FontFamily(
                    Font(R.font.publicsansregular, androidx.compose.ui.text.font.FontWeight.Normal),
                    Font(R.font.publicsansmedium, androidx.compose.ui.text.font.FontWeight.Medium),
                    Font(R.font.publicsansbold, androidx.compose.ui.text.font.FontWeight.Bold),
                )
            else -> FontFamily.Default
        }
    }
}
