package nashid.verify.sdk.data.repository

import nashid.verify.sdk.utils.Utility
import nashid.verify.sdk.viewmodel.CameraXLiveData
import java.util.Locale

class QatarIdCardRepository(
    private val cameraXLiveData: CameraXLiveData,
) {
    fun readQatarFrontViewData(originalText: String) {
        var text = originalText
        text = text.replace(" ", "").uppercase(Locale.getDefault())
        text = text.replace("\n", " ").uppercase(Locale.getDefault())
        val isQatarIdDetected = (
            (text.contains("STATEOFQATAR") || text.contains("QATARID"))
        )

        if (isQatarIdDetected) {
            handleQatarView()
        } else {
            cameraXLiveData.setIsSuccess(false)
        }
    }

    private fun handleQatarView() {
        cameraXLiveData.apply {
            setIdNo(null)
            setDOB(null)
            setExpiryDate(null)
            setIsFrontView(true)
            setIdLine1(false)
            setIdLine2(false)
            setIdLine3(false)
        }

        Utility.getInstance().apply {
            isBarCodeCard = true
            isQatarCard = true
            isUAECard = false
            isBahCard = false
            isOmanCard = false
        }
        cameraXLiveData.setCTimer(false)
    }
}
