package nashid.verify.sdk.data.repository

import nashid.verify.sdk.utils.Constants.UAE_ID_CARD_REGEX1
import nashid.verify.sdk.utils.Constants.UAE_ID_CARD_REGEX2
import nashid.verify.sdk.utils.Constants.UAE_ID_CARD_REGEX3
import nashid.verify.sdk.utils.ScanDocument
import nashid.verify.sdk.utils.Utility
import nashid.verify.sdk.utils.helpers.CardReaderHelper.Companion.replaceAlfaWithNumber
import nashid.verify.sdk.utils.helpers.CardReaderHelper.Companion.replaceNumberWithAlfa
import nashid.verify.sdk.viewmodel.CameraXLiveData
import java.util.Locale
import java.util.Objects
import java.util.regex.Pattern

class UAEIdCardRepository(
    private val cameraXLiveData: CameraXLiveData,
    private val scanDocument: ScanDocument,
) {
    fun readIdCardFrontView(originalText: String) {
        var text = originalText
        text = text.replace(" ", "").uppercase(Locale.getDefault())
        text = text.replace("\n", " ").uppercase(Locale.getDefault())
        if (text.contains("UNITEDARABEMIRATES") && text.contains("IDENTITYCARD") || text.contains("UNITEDARABEMIRATES")) {
            handleUAEFrontView()
        } else {
            cameraXLiveData.setIsSuccess(false)
        }
    }

    private fun handleUAEFrontView() {
        cameraXLiveData.setIdNo(null)
        cameraXLiveData.setDOB(null)
        cameraXLiveData.setExpiryDate(null)
        cameraXLiveData.setIsFrontView(true)
        cameraXLiveData.setIdLine1(true)
        cameraXLiveData.setIdLine2(true)
        Utility.getInstance().isUAECard = true
    }

    fun readIdCardBackView(textAll: Array<String>) {
        var gender = ""
        val pattern1 = Pattern.compile(UAE_ID_CARD_REGEX1)
        val pattern2 = Pattern.compile(UAE_ID_CARD_REGEX2)
        val pattern3 = Pattern.compile(UAE_ID_CARD_REGEX3)
        for (text in textAll) {
            if (text.length == 30) {
                val matcher1 = pattern1.matcher(text)
                val matcher2 = pattern2.matcher(text)
                val matcher3 = pattern3.matcher(text)
                if (matcher1.matches()) {
                    Utility.getInstance().mrzLine1 = text
                    cameraXLiveData.setIdNo(
                        replaceAlfaWithNumber(
                            Objects.requireNonNull(
                                matcher1.group(5),
                            ),
                        ),
                    )
                    val country = replaceNumberWithAlfa(Objects.requireNonNull(matcher1.group(2)))
                    Utility.getInstance().country = country
                    Utility.getInstance().documentType = matcher1.group(1)
                    val idNumber = matcher1.group(5)
                    Utility.getInstance().passportNumber = idNumber
                    Utility.getInstance().cardNumber = matcher1.group(3)
                    scanDocument.documentNo = matcher1.group(3)
                    cameraXLiveData.setIdLine1(false)
                }
                if (matcher2.matches()) {
                    Utility.getInstance().mrzLine2 = text.toString()
                    cameraXLiveData.setDOB(matcher2.group(1))
                    cameraXLiveData.setExpiryDate(matcher2.group(4))
                    val rawGender = matcher2.group(3)?.toString()?.trim()?.uppercase()
                    gender =
                        when (rawGender) {
                            "F", "E" -> "F" // Sometimes OCR might read F as E
                            "M" -> "M"
                            "X" -> "X"
                            else -> {
                                ""
                            }
                        }
                    Utility.getInstance().dateOfBirth = matcher2.group(1)
                    Utility.getInstance().expiryDate = matcher2.group(4)
                    Utility.getInstance().gender = gender.uppercase()

                    scanDocument.dateOfBirth = matcher2.group(1)
                    scanDocument.expiryDate = matcher2.group(4)
                    val nationality = matcher2.group(6)
                    Utility.getInstance().nationality = nationality
                    cameraXLiveData.setIdLine2(false)
                }
                if (matcher3.matches()) {
                    Utility.getInstance().name = text.replace(Regex("[<«]"), " ").replace(Regex("<{3,}[A-Z]"), "").trim()
                    Utility.getInstance().mrzLine3 = text
                    cameraXLiveData.setIdLine3(false)
                }
                if (cameraXLiveData.getIdLine1().value == false && cameraXLiveData.getIdLine2().value == false && cameraXLiveData.getIdLine3().value == false) {
                    cameraXLiveData.setFlag(false)
                    cameraXLiveData.setCloseAnalysisUseCase(true)
                    cameraXLiveData.setIsSuccess(true)
                    cameraXLiveData.setCTimer(true)
                    cameraXLiveData.setCaptureAnImage(true)
                    break
                }
            } else {
                cameraXLiveData.setIsSuccess(false)
            }
        }
    }
}
