package nashid.verify.sdk.ui.theme

import android.content.Context
import android.graphics.Typeface
import android.util.AttributeSet
import androidx.appcompat.widget.AppCompatTextView
import androidx.core.content.res.ResourcesCompat
import nashid.verify.sdkNew.R

class AppTextView
    @JvmOverloads
    constructor(
        context: Context,
        attrs: AttributeSet? = null,
        defStyle: Int = 0,
    ) : AppCompatTextView(context, attrs, defStyle) {
        init {
            applyFont()
        }

        private fun applyFont() {
            val weight =
                when (typeface?.style) {
                    Typeface.BOLD -> FontWeight.BOLD
                    Typeface.ITALIC -> FontWeight.MEDIUM
                    Typeface.NORMAL -> FontWeight.REGULAR
                    else -> FontWeight.REGULAR
                }

            try {
                val customTypeface = FontManager.getFont(context, weight)
                typeface = customTypeface
            } catch (e: Exception) {
                e.printStackTrace()
                typeface = ResourcesCompat.getFont(context, R.font.regular)
            }
        }
    }
