package nashid.verify.sdk.utils.helpers

import android.app.Activity
import android.content.Context
import android.widget.LinearLayout
import nashid.verify.sdk.utils.SdkConfig

class TextSizeConverter(
    private val context: Context,
) {
    private val scale: Float
        get() {
            val density = context.resources.displayMetrics.density
            val fontScale = context.resources.configuration.fontScale
            return density * fontScale
        }
    private val densityScale: Float
        get() = context.resources.displayMetrics.density // Used for dp-to-pixel conversions

    fun changeStatusBarColor(activity: Activity) {
        // Status bar color from branding (null means transparent)
        val statusBarColor = SdkConfig.sdkAppTheme.getBackgroundColorInt()

        // Use the new EdgeToEdgeHelper for proper Android 15+ handling
        EdgeToEdgeHelper.setupEdgeToEdgeWithStatusBar(activity, statusBarColor)
    }

    // Convert DP to pixels for width
    fun getWidth(dp: Int): Int = (dp * densityScale + 0.5f).toInt()

    // Convert DP to pixels for height
    fun getHeight(dp: Int): Int = (dp * densityScale + 0.5f).toInt()

    // Convert DP to pixels for padding or margin
    fun getPaddingOrMarginValue(dp: Int): Int = (dp * densityScale + 0.5f).toInt()

    // Convert DP to pixels for corner radius
    fun calculateRadius(dp: Int): Int = (dp * densityScale + 0.5f).toInt()

    fun getLinearLayoutParam(): LinearLayout.LayoutParams =
        LinearLayout.LayoutParams(
            LinearLayout.LayoutParams.MATCH_PARENT,
            LinearLayout.LayoutParams.WRAP_CONTENT,
        )

    fun getMatchParentLinearLayoutParam(): LinearLayout.LayoutParams =
        LinearLayout.LayoutParams(
            LinearLayout.LayoutParams.MATCH_PARENT,
            LinearLayout.LayoutParams.MATCH_PARENT,
        )

    // Get scaled text size in pixels
    fun getTextSize(textSize: Int): Int = (textSize * scale + 0.5f).toInt()
}
