package nashid.verify.sdk

import android.content.ContentProvider
import android.content.ContentValues
import android.database.Cursor
import android.net.Uri
import nashid.verify.sdk.utils.KoinEnvironment
import org.koin.android.ext.koin.androidContext
import org.koin.core.context.GlobalContext
import org.koin.core.context.loadKoinModules
import org.koin.core.context.startKoin

class VerifySDKInitProvider : ContentProvider() {
    override fun onCreate(): Boolean {
        val context = context?.applicationContext ?: return false
        val sdkModules = KoinEnvironment.getModules()
        val globalContext = GlobalContext.getOrNull()
        if (globalContext == null) {
            // Koin not started, start with SDK modules
            startKoin {
                androidContext(context)
                modules(sdkModules)
            }
        } else {
            // Koin already started (by app), just load SDK modules
            loadKoinModules(sdkModules)
        }
        return true
    }

    override fun query(
        uri: Uri,
        projection: Array<out String>?,
        selection: String?,
        selectionArgs: Array<out String>?,
        sortOrder: String?,
    ): Cursor? = null

    override fun getType(uri: Uri): String? = null

    override fun insert(
        uri: Uri,
        values: ContentValues?,
    ): Uri? = null

    override fun delete(
        uri: Uri,
        selection: String?,
        selectionArgs: Array<out String>?,
    ): Int = 0

    override fun update(
        uri: Uri,
        values: ContentValues?,
        selection: String?,
        selectionArgs: Array<out String>?,
    ): Int = 0
}
